import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';

import './display-duration.component.less';

export class DisplayDurationComponent extends Component {
    static propTypes = {
        duration: PropTypes.number.isRequired,
    };

    render() {
        const { duration } = this.props;
        return <span className="display-duration-view">{moment.duration(duration, 'ms').format('d[d] h[h] m[m]', { trim: false })}</span>;
    }
}
