import React from 'react';
import { mount } from 'enzyme/build';
import { XlrDeleteButton } from './delete.component';

describe('Delete component', () => {
    let item, modalHeader, onDelete, renderModalBodyFn, deleteComponent;

    beforeEach(() => {
        item = {
            id: 'Application/Folder222/Release1234',
            folderId: 'Application/Folder222',
            title: 'Delete Test',
        };
        modalHeader = 'Delete Release';
        renderModalBodyFn = jest.fn();
        onDelete = jest.fn();
        deleteComponent = mount(<XlrDeleteButton item={item} modalHeader={modalHeader} onDelete={onDelete} renderModalBodyFn={renderModalBodyFn} />);
    });

    test('should have correct properties', () => {
        expect(deleteComponent.props().item.id).toBe('Application/Folder222/Release1234');
        expect(deleteComponent.props().item.folderId).toBe('Application/Folder222');
        expect(deleteComponent.props().item.title).toBe('Delete Test');
        expect(deleteComponent.props().modalHeader).toBe('Delete Release');

        const deleteLink = deleteComponent.find('span.action-label');
        expect(deleteLink.text()).toContain('Delete');
    });

    test('should open confirmation dialog when enter key is pressed', () => {
        const deleteLink = deleteComponent.find('span.action-label');
        deleteLink.simulate('keyDown', { key: 'Enter', keyCode: 13, which: 13 });

        const dialog = deleteComponent.find('.xl-default-modal');
        dialog.simulate('keyDown', { key: 'Enter', keyCode: 13, which: 13 });
        expect(onDelete).toHaveBeenCalledTimes(1);
    });

    describe('Confirmation Dialog', () => {
        beforeEach(() => {
            const deleteLink = deleteComponent.find('span.action-label');
            deleteLink.simulate('click');
        });

        test('should call onDelete when enter key is pressed', () => {
            const dialog = deleteComponent.find('.xl-default-modal');
            dialog.simulate('keyDown', { key: 'Enter', keyCode: 13, which: 13 });
            expect(onDelete).toHaveBeenCalledTimes(1);
        });

        test('should call onDelete when delete key is pressed', () => {
            const dialog = deleteComponent.find('.xl-default-modal');
            dialog.simulate('keyDown', { key: 'Delete', keyCode: 46, which: 46 });
            expect(onDelete).toHaveBeenCalledTimes(1);
        });

        test('should call onDelete when delete button is clicked', () => {
            const deleteButton = deleteComponent.find('button.primary');
            deleteButton.simulate('click');
            expect(onDelete).toHaveBeenCalledTimes(1);
        });

        test('should not call onDelete when esc key is pressed', () => {
            const dialog = deleteComponent.find('.xl-default-modal');
            dialog.simulate('keyDown', { key: 'Esc', keyCode: 27, which: 27 });
            expect(onDelete).toHaveBeenCalledTimes(0);
        });

        test('should not call onDelete when cancel button is clicked', () => {
            const deleteButton = deleteComponent.find('button.cancel');
            deleteButton.simulate('click');
            expect(onDelete).toHaveBeenCalledTimes(0);
        });
    });
});
