import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {HeaderRow, ReleaseRow} from './const';
import {ReleaseHeaderLabelComponent} from './release-header-label.component';
import {ReleaseRowComponent} from './release-row.component';

import './release-list-common.component.less';

export class ReleaseListComponent extends Component {
    static propTypes = {
        dateFormat: PropTypes.string,
        header: PropTypes.arrayOf(HeaderRow).isRequired,
        loadingReleases: PropTypes.bool.isRequired,
        noData: PropTypes.node.isRequired,
        onOrderChange: PropTypes.func.isRequired,
        releases: PropTypes.arrayOf(ReleaseRow).isRequired,
        timeFormat: PropTypes.string
    };

    render() {
        const {loadingReleases, header, onOrderChange, releases, noData, dateFormat, timeFormat} = this.props;

        let content = noData;
        if (releases.length > 0) {
            const releaseRows = releases.map(release => (
                <ReleaseRowComponent
                    currentPhase={release.currentPhase}
                    dateFormat={dateFormat}
                    duration={release.duration}
                    endDate={release.endDate}
                    folders={release.folders}
                    id={release.id}
                    isArchived={release.isArchived}
                    key={release.id}
                    progress={release.progress}
                    startDate={release.startDate}
                    status={release.status}
                    timeFormat={timeFormat}
                    title={release.title}/>
            ));

            content = (
                <React.Fragment>
                    <h4 className="release-list-view-title">Search results (top {releases.length})</h4>
                    <ReleaseHeaderLabelComponent header={header} onOrderChange={onOrderChange}/>
                    {releaseRows}
                </React.Fragment>
            );
        }

        if (loadingReleases) {
            content = (
                <div className="spinner">
                    <img alt="Loading..." src="static/@project.version@/styles/img/big-ajax-loader.gif"/>
                </div>
            );
        }

        return (
            <div className="release-list-view">{content}</div>
        );
    }
}
