/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.plugins.providers.jaxb.json.JsonParsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
public class CiJsonMessageBodyReader
implements MessageBodyReader<ConfigurationItem> {
    private Repository repository;
    private static final Logger LOG = LoggerFactory.getLogger(CiJsonMessageBodyReader.class);

    @Autowired
    public CiJsonMessageBodyReader(Repository repository) {
        this.repository = repository;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public ConfigurationItem readFrom(Class<ConfigurationItem> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        CiJsonReader reader;
        JSONObject json;
        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        try {
            json = new JSONObject(JsonParsing.extractJsonMapString((Reader)new InputStreamReader(entityStream)));
            reader = new CiJsonReader(json);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
        ConfigurationItem result = null;
        try {
            result = converter.readCi((CiReader)reader);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Conversion error. Can't handle mapping this json: " + json + " to a CI");
            throw new IllegalArgumentException(e);
        }
        converter.resolveReferences(this.repository);
        return result;
    }
}

