/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsDecoratingModel;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNotWriteLockedException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsConcurrentModel
extends FsDecoratingModel<FsModel> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public FsConcurrentModel(FsModel model) {
        super(model);
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public void assertWriteLockedByCurrentThread() throws FsNotWriteLockedException {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            throw new FsNotWriteLockedException();
        }
    }

    void assertNotReadLockedByCurrentThread(@CheckForNull FsNotWriteLockedException ex) throws FsNotWriteLockedException {
        if (0 < this.lock.getReadHoldCount()) {
            throw new FsNotWriteLockedException(ex);
        }
    }
}

