/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.ConfigurationParameter;
import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.PluginException;
import fitnesse.PluginsLoader;
import fitnesse.authentication.Authenticator;
import fitnesse.components.ComponentFactory;
import fitnesse.components.Logger;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.ContentFilterResponder;
import fitnesse.testrunner.MultipleTestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.RecentChangesWikiPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.ZipFileVersionsController;
import fitnesse.wikitext.parser.SymbolProvider;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ContextConfigurator {
    private static final String DEFAULT_PATH = ".";
    public static final String DEFAULT_ROOT = "FitNesseRoot";
    public static final String DEFAULT_CONTEXT_ROOT = "/";
    private static final int DEFAULT_VERSION_DAYS = 14;
    private static final int DEFAULT_COMMAND_PORT = 9123;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_CONFIG_FILE = "plugins.properties";
    private WikiPage root;
    private Integer port;
    private String rootPath = ".";
    private String rootDirectoryName = "FitNesseRoot";
    private String contextRoot;
    private Logger logger;
    private Authenticator authenticator;
    private VersionsController versionsController;
    private RecentChanges recentChanges;
    private final Properties properties = new Properties();
    private TestSystemListener testSystemListener;

    private ContextConfigurator() {
    }

    public static ContextConfigurator empty() {
        return new ContextConfigurator();
    }

    public static ContextConfigurator systemDefaults() {
        return ContextConfigurator.empty().withRootPath(DEFAULT_PATH).withParameter(ConfigurationParameter.ROOT_DIRECTORY, DEFAULT_ROOT).withParameter(ConfigurationParameter.CONTEXT_ROOT, DEFAULT_CONTEXT_ROOT).withParameter(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS, Integer.toString(14)).withParameter(ConfigurationParameter.CONFIG_FILE, DEFAULT_CONFIG_FILE);
    }

    public ContextConfigurator updatedWith(Properties newProperties) {
        for (String key : newProperties.stringPropertyNames()) {
            this.withParameter(key, newProperties.getProperty(key));
        }
        return this;
    }

    public ContextConfigurator withTestSystemListener(TestSystemListener testSystemListener) {
        this.testSystemListener = testSystemListener;
        return this;
    }

    public FitNesseContext makeFitNesseContext() throws IOException, PluginException {
        ComponentFactory componentFactory = new ComponentFactory(this.properties);
        if (this.port == null) {
            this.port = this.getPort();
        }
        FitNesseVersion version = new FitNesseVersion();
        this.updateFitNesseProperties(version);
        WikiPageFactory wikiPageFactory = (WikiPageFactory)componentFactory.createComponent(ConfigurationParameter.WIKI_PAGE_FACTORY_CLASS, FileSystemPageFactory.class);
        if (this.versionsController == null) {
            this.versionsController = (VersionsController)componentFactory.createComponent(ConfigurationParameter.VERSIONS_CONTROLLER_CLASS, ZipFileVersionsController.class);
            Integer versionDays = this.getVersionDays();
            if (versionDays != null) {
                this.versionsController.setHistoryDepth(versionDays);
            }
        }
        if (this.recentChanges == null) {
            this.recentChanges = (RecentChanges)componentFactory.createComponent(ConfigurationParameter.RECENT_CHANGES_CLASS, RecentChangesWikiPage.class);
        }
        if (this.root == null) {
            this.root = wikiPageFactory.makePage(new File(this.rootPath, this.rootDirectoryName), this.rootDirectoryName, null);
        }
        PluginsLoader pluginsLoader = new PluginsLoader(componentFactory);
        if (this.logger == null) {
            this.logger = pluginsLoader.makeLogger(this.get(ConfigurationParameter.LOG_DIRECTORY));
        }
        if (this.authenticator == null) {
            this.authenticator = pluginsLoader.makeAuthenticator(this.get(ConfigurationParameter.CREDENTIALS));
        }
        SlimTableFactory slimTableFactory = new SlimTableFactory();
        CustomComparatorRegistry customComparatorRegistry = new CustomComparatorRegistry();
        MultipleTestSystemFactory testSystemFactory = new MultipleTestSystemFactory(slimTableFactory, customComparatorRegistry);
        FitNesseContext context = new FitNesseContext(version, this.root, this.rootPath, this.rootDirectoryName, this.contextRoot, this.versionsController, this.recentChanges, this.port, this.authenticator, this.logger, testSystemFactory, this.testSystemListener, this.properties);
        SymbolProvider symbolProvider = SymbolProvider.wikiParsingProvider;
        WikiPageFactoryRegistry wikiPageFactoryRegistry = (WikiPageFactoryRegistry)((Object)wikiPageFactory);
        pluginsLoader.loadPlugins(context.responderFactory, symbolProvider, wikiPageFactoryRegistry, testSystemFactory, slimTableFactory, customComparatorRegistry);
        pluginsLoader.loadResponders(context.responderFactory);
        pluginsLoader.loadWikiPageFactories(wikiPageFactory);
        pluginsLoader.loadTestSystems(testSystemFactory);
        pluginsLoader.loadSymbolTypes(symbolProvider);
        pluginsLoader.loadSlimTables(slimTableFactory);
        pluginsLoader.loadCustomComparators(customComparatorRegistry);
        ContentFilter contentFilter = pluginsLoader.loadContentFilter();
        if (contentFilter != null) {
            context.responderFactory.addFilter("save", new ContentFilterResponder(contentFilter));
        }
        return context;
    }

    private void updateFitNesseProperties(FitNesseVersion version) {
        if (this.rootPath != null) {
            this.properties.setProperty("FITNESSE_ROOTPATH", this.rootPath);
        }
        this.properties.setProperty("FITNESSE_PORT", Integer.toString(this.port));
        this.properties.setProperty("FITNESSE_VERSION", version.toString());
        for (ConfigurationParameter parameter : ConfigurationParameter.values()) {
            String value = this.get(parameter);
            if (value == null) continue;
            this.properties.setProperty(parameter.getKey(), value);
        }
    }

    private int getPort() {
        if (this.port == null) {
            if (this.get(ConfigurationParameter.COMMAND) != null) {
                return 9123;
            }
            return 80;
        }
        return this.port;
    }

    public ContextConfigurator withRoot(WikiPage root) {
        this.root = root;
        return this;
    }

    public ContextConfigurator withRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public ContextConfigurator withParameter(String key, String value) {
        ConfigurationParameter parameter = ConfigurationParameter.byKey(key);
        if (parameter == null) {
            this.properties.put(key, value);
        } else {
            this.withParameter(parameter, value);
        }
        return this;
    }

    public ContextConfigurator withParameter(ConfigurationParameter parameter, String value) {
        switch (parameter) {
            case ROOT_PATH: {
                this.rootPath = value;
                break;
            }
            case ROOT_DIRECTORY: {
                this.rootDirectoryName = value;
                break;
            }
            case CONTEXT_ROOT: {
                this.contextRoot = value;
                if (!this.contextRoot.startsWith(DEFAULT_CONTEXT_ROOT)) {
                    this.contextRoot = DEFAULT_CONTEXT_ROOT + this.contextRoot;
                }
                if (this.contextRoot.endsWith(DEFAULT_CONTEXT_ROOT)) break;
                this.contextRoot = this.contextRoot + DEFAULT_CONTEXT_ROOT;
                break;
            }
            case PORT: {
                this.port = Integer.parseInt(value);
            }
            default: {
                this.properties.setProperty(parameter.getKey(), value);
            }
        }
        return this;
    }

    public ContextConfigurator withRootDirectoryName(String rootDirectoryName) {
        this.rootDirectoryName = rootDirectoryName;
        return this;
    }

    public ContextConfigurator withPort(int port) {
        this.port = port;
        return this;
    }

    public ContextConfigurator withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public ContextConfigurator withVersionsController(VersionsController versionsController) {
        this.versionsController = versionsController;
        return this;
    }

    public ContextConfigurator withRecentChanges(RecentChanges recentChanges) {
        this.recentChanges = recentChanges;
        return this;
    }

    public String get(ConfigurationParameter parameter) {
        switch (parameter) {
            case ROOT_PATH: {
                return this.rootPath;
            }
            case ROOT_DIRECTORY: {
                return this.rootDirectoryName;
            }
            case CONTEXT_ROOT: {
                return this.contextRoot;
            }
            case PORT: {
                return String.valueOf(this.port);
            }
        }
        return this.properties.getProperty(parameter.getKey());
    }

    public Integer getVersionDays() {
        String days = this.get(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS);
        return days == null ? null : Integer.valueOf(Integer.parseInt(days));
    }
}

