/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.html.template.PageFactory;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import util.Clock;

public class CompositeExecutionLog
implements ExecutionLogListener {
    private final WikiPage testPage;
    private final String testPagePath;
    private WikiPagePath errorLogPagePath;
    private ExecutionLog executionLog;
    private Map<String, ExecutionLog> logs = new HashMap<String, ExecutionLog>();
    private long startTime;

    public CompositeExecutionLog(WikiPage testPage) {
        this.testPage = testPage;
        PageCrawler crawler = testPage.getPageCrawler();
        this.testPagePath = "." + crawler.getFullPath();
        this.errorLogPagePath = crawler.getFullPath().addNameToFront("ErrorLogs");
    }

    public void publish(PageFactory pageFactory) {
        String content = this.buildLogContent(pageFactory);
        PageCrawler crawler = this.testPage.getPageCrawler();
        WikiPage root = crawler.getRoot();
        WikiPage errorLogPage = WikiPageUtil.addPage(root, this.errorLogPagePath);
        PageData data = errorLogPage.getData();
        if (root != null) {
            PageData pageData;
            String tags;
            WikiPagePath wpp = new WikiPagePath(this.errorLogPagePath.getRest());
            WikiPage wikiPage = root.getPageCrawler().getPage(wpp);
            if (wikiPage != null && (tags = (pageData = wikiPage.getData()).getAttribute("Suites")) != null && !"".equals(tags)) {
                data.setAttribute("Suites", tags);
            }
        }
        data.setContent(content);
        errorLogPage.commit(data);
    }

    String buildLogContent(PageFactory pageFactory) {
        VelocityContext context = new VelocityContext();
        context.put("currentDate", this.makeDateFormat().format(Clock.currentDate()));
        context.put("testPage", this.testPagePath);
        context.put("logs", this.logs);
        return pageFactory.render(context, "executionLog.vm");
    }

    public String getErrorLogPageName() {
        return PathParser.render(this.errorLogPagePath);
    }

    public int exceptionCount() {
        int count = 0;
        for (ExecutionLog log : this.logs.values()) {
            count += log.getExceptions().size();
        }
        return count;
    }

    public boolean hasCapturedOutput() {
        for (ExecutionLog log : this.logs.values()) {
            if ("".equals(log.getCapturedOutput())) continue;
            return true;
        }
        return false;
    }

    private SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("h:mm:ss a (z) 'on' EEEE, MMMM d, yyyy");
    }

    @Override
    public void commandStarted(ExecutionLogListener.ExecutionContext context) {
        this.executionLog = new ExecutionLog();
        this.executionLog.command = context.getCommand();
        this.startTime = Clock.currentTimeInMillis();
        this.logs.put(context.getTestSystemName(), this.executionLog);
    }

    @Override
    public void stdOut(String output) {
        this.executionLog.capturedOutput.append(output).append("\n");
    }

    @Override
    public void stdErr(String output) {
        this.executionLog.capturedError.append(output).append("\n");
    }

    @Override
    public void exitCode(int exitCode) {
        long endTime = Clock.currentTimeInMillis();
        this.executionLog.executionTime = endTime - this.startTime;
        this.executionLog.exitCode = exitCode;
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        this.executionLog.exceptions.add(e);
    }

    public static class ExecutionLog {
        private String command = "";
        private long executionTime;
        private int exitCode;
        private StringBuilder capturedOutput = new StringBuilder();
        private StringBuilder capturedError = new StringBuilder();
        private List<Throwable> exceptions = new LinkedList<Throwable>();

        public String getCommand() {
            return this.command;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getCapturedOutput() {
            return this.capturedOutput.toString();
        }

        public String getCapturedError() {
            return this.capturedError.toString();
        }

        public List<Throwable> getExceptions() {
            return this.exceptions;
        }
    }
}

