/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.slim.SlimClientBuilder;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import java.io.IOException;

public class InProcessSlimClientBuilder
extends SlimClientBuilder {
    public InProcessSlimClientBuilder(Descriptor descriptor) {
        super(descriptor);
    }

    @Override
    public SlimCommandRunningClient build() throws IOException {
        MockCommandRunner commandRunner = new MockCommandRunner(this.getExecutionLogListener());
        String[] slimArguments = this.buildArguments();
        this.createSlimService(slimArguments);
        return new SlimCommandRunningClient(commandRunner, this.determineSlimHost(), this.getSlimPort(), this.determineTimeout(), this.getSlimVersion());
    }

    void createSlimService(String[] args) throws IOException {
        while (!this.tryCreateSlimService(args)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean tryCreateSlimService(String[] args) throws IOException {
        try {
            SlimService.Options options = SlimService.parseCommandLine(args);
            SlimService.startWithFactoryAsync(JavaSlimFactory.createJavaSlimFactory(options), options);
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

