/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.CompositeTestSystemListener;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SlimTestSystem
implements TestSystem {
    private static final Logger LOG = Logger.getLogger(SlimTestSystem.class.getName());
    public static final SlimTable START_OF_TEST = null;
    public static final SlimTable END_OF_TEST = null;
    private final SlimClient slimClient;
    private final CompositeTestSystemListener testSystemListener;
    private final String testSystemName;
    private SlimTestContextImpl testContext;
    private boolean stopTestCalled;
    private boolean testSystemIsStopped;

    public SlimTestSystem(String testSystemName, SlimClient slimClient) {
        this.testSystemName = testSystemName;
        this.slimClient = slimClient;
        this.testSystemListener = new CompositeTestSystemListener();
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    @Override
    public String getName() {
        return this.testSystemName;
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return true;
    }

    @Override
    public void start() throws IOException {
        try {
            this.slimClient.start();
            this.testSystemListener.testSystemStarted(this);
        }
        catch (SlimError e) {
            this.exceptionOccurred(e);
        }
    }

    @Override
    public void kill() throws IOException {
        this.slimClient.kill();
    }

    @Override
    public void bye() throws IOException {
        try {
            this.slimClient.bye();
            this.testSystemStopped(null);
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
            throw e;
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    @Override
    public void runTests(TestPage pageToTest) throws IOException {
        this.initializeTest();
        this.testStarted(pageToTest);
        this.processAllTablesOnPage(pageToTest);
        this.testComplete(pageToTest, this.testContext.getTestSummary());
    }

    @Override
    public void addTestSystemListener(TestSystemListener listener) {
        this.testSystemListener.addTestSystemListener(listener);
    }

    private void initializeTest() {
        this.testContext = new SlimTestContextImpl();
        this.stopTestCalled = false;
    }

    protected abstract void processAllTablesOnPage(TestPage var1) throws IOException;

    protected void processTable(SlimTable table) throws IOException, SyntaxError {
        Map<String, Object> instructionResults;
        List<SlimAssertion> assertions = this.createAssertions(table);
        if (!this.stopTestCalled) {
            try {
                instructionResults = this.slimClient.invokeAndGetResponse(SlimAssertion.getInstructions(assertions));
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
                throw e;
            }
        } else {
            instructionResults = Collections.emptyMap();
        }
        this.evaluateTables(assertions, instructionResults);
    }

    private List<SlimAssertion> createAssertions(SlimTable table) throws SyntaxError {
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        assertions.addAll(table.getAssertions());
        return assertions;
    }

    protected void evaluateTables(List<SlimAssertion> assertions, Map<String, Object> instructionResults) {
        for (SlimAssertion a : assertions) {
            try {
                String key = a.getInstruction().getId();
                Object returnValue = instructionResults.get(key);
                if (returnValue != null && returnValue instanceof String && ((String)returnValue).startsWith("__EXCEPTION__:")) {
                    SlimExceptionResult exceptionResult = this.makeExceptionResult(key, (String)returnValue);
                    if (exceptionResult.isStopTestException()) {
                        this.stopTestCalled = true;
                    }
                    if ((exceptionResult = a.getExpectation().evaluateException(exceptionResult)) == null) continue;
                    this.testExceptionOccurred(a, exceptionResult);
                    continue;
                }
                TestResult testResult = a.getExpectation().evaluateExpectation(returnValue);
                this.testAssertionVerified(a, testResult);
            }
            catch (Throwable ex) {
                this.exceptionOccurred(ex);
            }
        }
    }

    private SlimExceptionResult makeExceptionResult(String resultKey, String resultString) {
        SlimExceptionResult exceptionResult = new SlimExceptionResult(resultKey, resultString);
        return exceptionResult;
    }

    protected void testOutputChunk(String output) throws IOException {
        this.testSystemListener.testOutputChunk(output);
    }

    protected void testStarted(TestPage testPage) throws IOException {
        this.testSystemListener.testStarted(testPage);
    }

    protected void testComplete(TestPage testPage, TestSummary testSummary) throws IOException {
        this.testSystemListener.testComplete(testPage, testSummary);
    }

    protected void exceptionOccurred(Throwable e) {
        try {
            this.slimClient.kill();
        }
        catch (IOException e1) {
            LOG.log(Level.WARNING, "Failed to kill SLiM client", e);
        }
        this.testSystemStopped(e);
    }

    protected void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.testSystemListener.testAssertionVerified(assertion, testResult);
    }

    protected void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.testSystemListener.testExceptionOccurred(assertion, exceptionResult);
    }

    protected void testSystemStopped(Throwable e) {
        if (this.testSystemIsStopped) {
            return;
        }
        this.testSystemIsStopped = true;
        this.testSystemListener.testSystemStopped(this, e);
    }
}

