/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.SourcePage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import util.Maybe;
import util.StringUtil;

public class WikiSourcePage
implements SourcePage {
    private static final Logger LOG = Logger.getLogger(WikiSourcePage.class.getName());
    private WikiPage page;

    public WikiSourcePage(WikiPage page) {
        this.page = page;
    }

    @Override
    public String getName() {
        return this.page.getName();
    }

    @Override
    public String getFullName() {
        return this.page.getPageCrawler().getFullPath().toString();
    }

    @Override
    public String getPath() {
        return this.page.getPageCrawler().getFullPath().parentPath().toString();
    }

    @Override
    public String getFullPath() {
        return this.page.getPageCrawler().getFullPath().toString();
    }

    @Override
    public String getContent() {
        return this.page.getData().getContent();
    }

    @Override
    public boolean targetExists(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse(wikiWordPath);
        WikiPage parentPage = this.page.getParent();
        return parentPage.getPageCrawler().getPage(pathOfWikiWord) != null;
    }

    @Override
    public String makeFullPathOfTarget(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse(wikiWordPath);
        if (pathOfWikiWord == null) {
            throw new IllegalArgumentException("Can't parse path: " + wikiWordPath);
        }
        WikiPage parentPage = this.page.getParent();
        return PathParser.render(parentPage.getPageCrawler().getFullPathOfChild(pathOfWikiWord));
    }

    @Override
    public String findParentPath(String targetName) {
        String[] pathElements = targetName.split("\\.");
        String target = pathElements[0];
        PageCrawler crawler = this.page.getPageCrawler();
        WikiPage ancestor = crawler.findAncestorWithName(target);
        if (ancestor != null) {
            pathElements[0] = PathParser.render(ancestor.getPageCrawler().getFullPath());
            return "." + StringUtil.join(Arrays.asList(pathElements), ".");
        }
        return "." + targetName;
    }

    @Override
    public Maybe<SourcePage> findIncludedPage(String pageName) {
        PageCrawler crawler = this.page.getPageCrawler();
        WikiPagePath pagePath = PathParser.parse(pageName);
        if (pagePath == null) {
            return Maybe.nothingBecause("Page include failed because the page " + pageName + " does not have a valid WikiPage name.");
        }
        WikiPage includedPage = crawler.getSiblingPage(pagePath);
        if (includedPage == null) {
            return Maybe.nothingBecause("Page include failed because the page " + pageName + " does not exist.");
        }
        if (this.isParentOf(includedPage)) {
            return Maybe.nothingBecause("Error! Cannot include parent page (" + pageName + ").");
        }
        return new Maybe<SourcePage>(new WikiSourcePage(includedPage));
    }

    @Override
    public Collection<SourcePage> getAncestors() {
        ArrayList<SourcePage> ancestors = new ArrayList<SourcePage>();
        for (WikiPage ancestor = this.page.getParent(); ancestor != null && ancestor != this.page; ancestor = ancestor.getParent()) {
            ancestors.add(new WikiSourcePage(ancestor));
            if (ancestor.isRoot()) break;
        }
        return ancestors;
    }

    @Override
    public Collection<SourcePage> getChildren() {
        ArrayList<SourcePage> children = new ArrayList<SourcePage>();
        for (WikiPage child : this.page.getChildren()) {
            children.add(new WikiSourcePage(child));
        }
        return children;
    }

    @Override
    public boolean hasProperty(String propertyKey) {
        return this.page.getData().getProperties().has(propertyKey);
    }

    @Override
    public String getProperty(String propertyKey) {
        String propertyValue = this.page.getData().getAttribute(propertyKey);
        return propertyValue != null ? propertyValue.trim() : "";
    }

    @Override
    public String makeUrl(String wikiWordPath) {
        return this.makeFullPathOfTarget(wikiWordPath);
    }

    private boolean isParentOf(WikiPage possibleParent) {
        for (WikiPage candidate = this.page; candidate.getParent() != candidate; candidate = candidate.getParent()) {
            if (possibleParent != candidate) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(SourcePage other) {
        return this.getName().compareTo(other.getName());
    }
}

