/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;

public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContent {
    private ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, FieldMappingMetaData>>> mappings = ImmutableMap.of();

    GetFieldMappingsResponse(ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, FieldMappingMetaData>>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse() {
    }

    public ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, FieldMappingMetaData>>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetaData fieldMappings(String index, String type, String field) {
        ImmutableMap<String, ImmutableMap<String, FieldMappingMetaData>> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        ImmutableMap<String, FieldMappingMetaData> typeMapping = indexMapping.get(type);
        if (typeMapping == null) {
            return null;
        }
        return typeMapping.get(field);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry indexEntry : this.mappings.entrySet()) {
            builder.startObject((String)indexEntry.getKey(), XContentBuilder.FieldCaseConversion.NONE);
            builder.startObject("mappings");
            for (Map.Entry typeEntry : ((ImmutableMap)indexEntry.getValue()).entrySet()) {
                builder.startObject((String)typeEntry.getKey(), XContentBuilder.FieldCaseConversion.NONE);
                for (Map.Entry fieldEntry : ((ImmutableMap)typeEntry.getValue()).entrySet()) {
                    builder.startObject((String)fieldEntry.getKey());
                    ((FieldMappingMetaData)fieldEntry.getValue()).toXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableMap.Builder indexMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            int typesSize = in.readVInt();
            ImmutableMap.Builder typeMapBuilder = ImmutableMap.builder();
            for (int j = 0; j < typesSize; ++j) {
                String type = in.readString();
                ImmutableMap.Builder<String, FieldMappingMetaData> fieldMapBuilder = ImmutableMap.builder();
                int fieldSize = in.readVInt();
                for (int k = 0; k < fieldSize; ++k) {
                    fieldMapBuilder.put(in.readString(), new FieldMappingMetaData(in.readString(), in.readBytesReference()));
                }
                typeMapBuilder.put(type, fieldMapBuilder.build());
            }
            indexMapBuilder.put(index, typeMapBuilder.build());
        }
        this.mappings = indexMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry indexEntry : this.mappings.entrySet()) {
            out.writeString((String)indexEntry.getKey());
            out.writeVInt(((ImmutableMap)indexEntry.getValue()).size());
            for (Map.Entry typeEntry : ((ImmutableMap)indexEntry.getValue()).entrySet()) {
                out.writeString((String)typeEntry.getKey());
                out.writeVInt(((ImmutableMap)typeEntry.getValue()).size());
                for (Map.Entry fieldEntry : ((ImmutableMap)typeEntry.getValue()).entrySet()) {
                    out.writeString((String)fieldEntry.getKey());
                    FieldMappingMetaData fieldMapping = (FieldMappingMetaData)fieldEntry.getValue();
                    out.writeString(fieldMapping.fullName());
                    out.writeBytesReference(fieldMapping.source);
                }
            }
        }
    }

    public static class FieldMappingMetaData
    implements ToXContent {
        public static final FieldMappingMetaData NULL = new FieldMappingMetaData("", BytesArray.EMPTY);
        private String fullName;
        private BytesReference source;

        public FieldMappingMetaData(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true).v2();
        }

        public boolean isNull() {
            return NULL.fullName().equals(this.fullName) && FieldMappingMetaData.NULL.source.length() == this.source.length();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("full_name", this.fullName);
            XContentHelper.writeRawField("mapping", this.source, builder, params);
            return builder;
        }
    }
}

