/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.settings.NodeSettingsService;

public class DiscoverySettings
extends AbstractComponent {
    public static final String PUBLISH_TIMEOUT = "discovery.zen.publish_timeout";
    public static final TimeValue DEFAULT_PUBLISH_TIMEOUT = TimeValue.timeValueSeconds(30L);
    private volatile TimeValue publishTimeout = DEFAULT_PUBLISH_TIMEOUT;

    @Inject
    public DiscoverySettings(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        nodeSettingsService.addListener(new ApplySettings());
    }

    public TimeValue getPublishTimeout() {
        return this.publishTimeout;
    }

    private class ApplySettings
    implements NodeSettingsService.Listener {
        private ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue newPublishTimeout = settings.getAsTime(DiscoverySettings.PUBLISH_TIMEOUT, null);
            if (newPublishTimeout != null && newPublishTimeout.millis() != DiscoverySettings.this.publishTimeout.millis()) {
                DiscoverySettings.this.logger.info("updating [{}] from [{}] to [{}]", DiscoverySettings.PUBLISH_TIMEOUT, DiscoverySettings.this.publishTimeout, newPublishTimeout);
                DiscoverySettings.this.publishTimeout = newPublishTimeout;
            }
        }
    }
}

