/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.GeoDistanceComparator;
import org.elasticsearch.search.MultiValueMode;

public class GeoDistanceComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexGeoPointFieldData<?> indexFieldData;
    private final double lat;
    private final double lon;
    private final DistanceUnit unit;
    private final GeoDistance geoDistance;
    private final MultiValueMode sortMode;

    public GeoDistanceComparatorSource(IndexGeoPointFieldData<?> indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, MultiValueMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.geoDistance = geoDistance;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData.getFieldNames().indexName().equals(fieldname));
        return new GeoDistanceComparator(numHits, this.indexFieldData, this.lat, this.lon, this.unit, this.geoDistance, this.sortMode);
    }
}

