/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.XOrdinalMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class InternalGlobalOrdinalsBuilder
extends AbstractIndexComponent
implements GlobalOrdinalsBuilder {
    public InternalGlobalOrdinalsBuilder(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public IndexFieldData.WithOrdinals build(IndexReader indexReader, IndexFieldData.WithOrdinals indexFieldData, Settings settings, CircuitBreakerService breakerService) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTime = System.currentTimeMillis();
        AtomicFieldData.WithOrdinals[] atomicFD = new AtomicFieldData.WithOrdinals[indexReader.leaves().size()];
        TermsEnum[] subs = new TermsEnum[indexReader.leaves().size()];
        long[] weights = new long[subs.length];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = indexFieldData.load((AtomicReaderContext)indexReader.leaves().get(i));
            BytesValues.WithOrdinals v = atomicFD[i].getBytesValues();
            subs[i] = v.getTermsEnum();
            weights[i] = v.getMaxOrd();
        }
        XOrdinalMap ordinalMap = XOrdinalMap.build(null, subs, weights, 0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breakerService.getBreaker().addWithoutBreaking(memorySizeInBytes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Global-ordinals[{}][{}] took {} ms", indexFieldData.getFieldNames().fullName(), ordinalMap.getValueCount(), System.currentTimeMillis() - startTime);
        }
        return new InternalGlobalOrdinalsIndexFieldData(indexFieldData.index(), settings, indexFieldData.getFieldNames(), indexFieldData.getFieldDataType(), atomicFD, ordinalMap, memorySizeInBytes);
    }
}

