/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class GeoPointDoubleArrayAtomicFieldData
extends AtomicGeoPointFieldData<ScriptDocValues> {
    protected long size = -1L;

    @Override
    public void close() {
    }

    @Override
    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.GeoPoints(this.getGeoPointValues());
    }

    public static class Single
    extends GeoPointDoubleArrayAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;

        public Single(DoubleArray lon, DoubleArray lat) {
            this.lon = lon;
            this.lat = lat;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 8L + (this.lon.ramBytesUsed() + this.lat.ramBytesUsed());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingle(this.lon, this.lat);
        }

        static class GeoPointValuesSingle
        extends GeoPointValues {
            private final DoubleArray lon;
            private final DoubleArray lat;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingle(DoubleArray lon, DoubleArray lat) {
                super(false);
                this.lon = lon;
                this.lat = lat;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public GeoPoint nextValue() {
                return this.scratch.reset(this.lat.get(this.docId), this.lon.get(this.docId));
            }
        }
    }

    public static class SingleFixedSet
    extends GeoPointDoubleArrayAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final FixedBitSet set;

        public SingleFixedSet(DoubleArray lon, DoubleArray lat, FixedBitSet set) {
            this.lon = lon;
            this.lat = lat;
            this.set = set;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed() + RamUsageEstimator.sizeOf((long[])this.set.getBits());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingleFixedSet(this.lon, this.lat, this.set);
        }

        static class GeoPointValuesSingleFixedSet
        extends GeoPointValues {
            private final DoubleArray lon;
            private final DoubleArray lat;
            private final FixedBitSet set;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingleFixedSet(DoubleArray lon, DoubleArray lat, FixedBitSet set) {
                super(false);
                this.lon = lon;
                this.lat = lat;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public GeoPoint nextValue() {
                return this.scratch.reset(this.lat.get(this.docId), this.lon.get(this.docId));
            }
        }
    }

    static class WithOrdinals
    extends GeoPointDoubleArrayAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final Ordinals ordinals;

        public WithOrdinals(DoubleArray lon, DoubleArray lat, Ordinals ordinals) {
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesWithOrdinals(this.lon, this.lat, this.ordinals.ordinals());
        }

        public static class GeoPointValuesWithOrdinals
        extends GeoPointValues {
            private final DoubleArray lon;
            private final DoubleArray lat;
            private final BytesValues.WithOrdinals ordinals;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesWithOrdinals(DoubleArray lon, DoubleArray lat, BytesValues.WithOrdinals ordinals) {
                super(ordinals.isMultiValued());
                this.lon = lon;
                this.lat = lat;
                this.ordinals = ordinals;
            }

            @Override
            public GeoPoint nextValue() {
                long ord = this.ordinals.nextOrd();
                return this.scratch.reset(this.lat.get(ord), this.lon.get(ord));
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.ordinals.setDocument(docId);
            }
        }
    }
}

