/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.warmer.put;

import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.AcknowledgedRestListener;

public class RestPutWarmerAction
extends BaseRestHandler {
    @Inject
    public RestPutWarmerAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_warmers/{name}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        PutWarmerRequest putWarmerRequest = new PutWarmerRequest(request.param("name"));
        putWarmerRequest.listenerThreaded(false);
        SearchRequest searchRequest = new SearchRequest(Strings.splitStringByCommaToArray(request.param("index"))).types(Strings.splitStringByCommaToArray(request.param("type"))).source(request.content(), request.contentUnsafe());
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
        putWarmerRequest.searchRequest(searchRequest);
        putWarmerRequest.timeout(request.paramAsTime("timeout", putWarmerRequest.timeout()));
        putWarmerRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putWarmerRequest.masterNodeTimeout()));
        client.admin().indices().putWarmer(putWarmerRequest, new AcknowledgedRestListener<PutWarmerResponse>(channel));
    }
}

