/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.deletebyquery;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestDeleteByQueryAction
extends BaseRestHandler {
    @Inject
    public RestDeleteByQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_query", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_query", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String consistencyLevel;
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        deleteByQueryRequest.listenerThreaded(false);
        if (request.hasContent()) {
            deleteByQueryRequest.source(request.content(), request.contentUnsafe());
        } else {
            String source = request.param("source");
            if (source != null) {
                deleteByQueryRequest.source(source);
            } else {
                QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
                if (querySourceBuilder != null) {
                    deleteByQueryRequest.source(querySourceBuilder);
                }
            }
        }
        deleteByQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        deleteByQueryRequest.timeout(request.paramAsTime("timeout", ShardDeleteByQueryRequest.DEFAULT_TIMEOUT));
        deleteByQueryRequest.routing(request.param("routing"));
        String replicationType = request.param("replication");
        if (replicationType != null) {
            deleteByQueryRequest.replicationType(ReplicationType.fromString(replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            deleteByQueryRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
        }
        deleteByQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, deleteByQueryRequest.indicesOptions()));
        client.deleteByQuery(deleteByQueryRequest, (ActionListener<DeleteByQueryResponse>)new RestBuilderListener<DeleteByQueryResponse>(channel){

            @Override
            public RestResponse buildResponse(DeleteByQueryResponse result, XContentBuilder builder) throws Exception {
                RestStatus restStatus = result.status();
                builder.startObject();
                builder.startObject(Fields._INDICES);
                for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : result.getIndices().values()) {
                    builder.startObject(indexDeleteByQueryResponse.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                    builder.startObject(Fields._SHARDS);
                    builder.field(Fields.TOTAL, indexDeleteByQueryResponse.getTotalShards());
                    builder.field(Fields.SUCCESSFUL, indexDeleteByQueryResponse.getSuccessfulShards());
                    builder.field(Fields.FAILED, indexDeleteByQueryResponse.getFailedShards());
                    ShardOperationFailedException[] failures = indexDeleteByQueryResponse.getFailures();
                    if (failures != null && failures.length > 0) {
                        builder.startArray(Fields.FAILURES);
                        for (ShardOperationFailedException shardFailure : failures) {
                            builder.startObject();
                            builder.field(Fields.INDEX, shardFailure.index());
                            builder.field(Fields.SHARD, shardFailure.shardId());
                            builder.field(Fields.REASON, shardFailure.reason());
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                builder.endObject();
                return new BytesRestResponse(restStatus, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString _INDICES = new XContentBuilderString("_indices");
        static final XContentBuilderString _SHARDS = new XContentBuilderString("_shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");

        Fields() {
        }
    }
}

