/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.Facets;
import org.elasticsearch.search.facet.InternalFacet;

public class InternalFacets
implements Facets,
Streamable,
ToXContent,
Iterable<Facet> {
    private List<Facet> facets = ImmutableList.of();
    private Map<String, Facet> facetsAsMap;

    private InternalFacets() {
    }

    public InternalFacets(List<Facet> facets) {
        this.facets = facets;
    }

    @Override
    public Iterator<Facet> iterator() {
        return this.facets.iterator();
    }

    @Override
    public List<Facet> facets() {
        return this.facets;
    }

    @Override
    public Map<String, Facet> getFacets() {
        return this.facetsAsMap();
    }

    @Override
    public Map<String, Facet> facetsAsMap() {
        if (this.facetsAsMap != null) {
            return this.facetsAsMap;
        }
        HashMap<String, Facet> facetsAsMap = Maps.newHashMap();
        for (Facet facet : this.facets) {
            facetsAsMap.put(facet.getName(), facet);
        }
        this.facetsAsMap = facetsAsMap;
        return facetsAsMap;
    }

    @Override
    public <T extends Facet> T facet(Class<T> facetType, String name) {
        return (T)((Facet)facetType.cast(this.facet(name)));
    }

    @Override
    public <T extends Facet> T facet(String name) {
        return (T)this.facetsAsMap().get(name);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FACETS);
        for (Facet facet : this.facets) {
            ((InternalFacet)facet).toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static InternalFacets readFacets(StreamInput in) throws IOException {
        InternalFacets result = new InternalFacets();
        result.readFrom(in);
        return result;
    }

    public static InternalFacets readOptionalFacets(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new InternalFacets());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            this.facets = ImmutableList.of();
            this.facetsAsMap = ImmutableMap.of();
        } else {
            this.facets = Lists.newArrayListWithCapacity(size);
            for (int i = 0; i < size; ++i) {
                BytesReference type = in.readBytesReference();
                Facet facet = InternalFacet.Streams.stream(type).readFacet(in);
                this.facets.add(facet);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.facets.size());
        for (Facet facet : this.facets) {
            InternalFacet internalFacet = (InternalFacet)facet;
            out.writeBytesReference(internalFacet.streamType());
            internalFacet.writeTo(out);
        }
    }

    static final class Fields {
        static final XContentBuilderString FACETS = new XContentBuilderString("facets");

        Fields() {
        }
    }
}

