/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.List;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.search.facet.FacetExecutor;

public class SearchContextFacets {
    private final List<Entry> entries;
    private boolean hasQuery;
    private boolean hasGlobal;

    public SearchContextFacets(List<Entry> entries) {
        this.entries = entries;
        for (Entry entry : entries) {
            if (entry.global) {
                this.hasGlobal = true;
                continue;
            }
            this.hasQuery = true;
        }
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public boolean hasQuery() {
        return this.hasQuery;
    }

    public boolean hasGlobal() {
        return this.hasGlobal;
    }

    public static class Entry {
        private final String facetName;
        private final FacetExecutor.Mode mode;
        private final FacetExecutor facetExecutor;
        private final boolean global;
        @Nullable
        private final Filter filter;

        public Entry(String facetName, FacetExecutor.Mode mode, FacetExecutor facetExecutor, boolean global, @Nullable Filter filter) {
            this.facetName = facetName;
            this.mode = mode;
            this.facetExecutor = facetExecutor;
            this.global = global;
            this.filter = filter;
        }

        public String getFacetName() {
            return this.facetName;
        }

        public FacetExecutor.Mode getMode() {
            return this.mode;
        }

        public FacetExecutor getFacetExecutor() {
            return this.facetExecutor;
        }

        public boolean isGlobal() {
            return this.global;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }
}

