/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class SimpleTextDocValuesWriter
extends DocValuesConsumer {
    static final BytesRef END = new BytesRef((CharSequence)"END");
    static final BytesRef FIELD = new BytesRef((CharSequence)"field ");
    static final BytesRef TYPE = new BytesRef((CharSequence)"  type ");
    static final BytesRef MINVALUE = new BytesRef((CharSequence)"  minvalue ");
    static final BytesRef PATTERN = new BytesRef((CharSequence)"  pattern ");
    static final BytesRef LENGTH = new BytesRef((CharSequence)"length ");
    static final BytesRef MAXLENGTH = new BytesRef((CharSequence)"  maxlength ");
    static final BytesRef NUMVALUES = new BytesRef((CharSequence)"  numvalues ");
    static final BytesRef ORDPATTERN = new BytesRef((CharSequence)"  ordpattern ");
    IndexOutput data;
    final BytesRef scratch = new BytesRef();
    final int numDocs;
    private final Set<String> fieldsSeen = new HashSet<String>();

    public SimpleTextDocValuesWriter(SegmentWriteState state, String ext) throws IOException {
        this.data = state.directory.createOutput(IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)ext), state.context);
        this.numDocs = state.segmentInfo.getDocCount();
    }

    private boolean fieldSeen(String field) {
        assert (!this.fieldsSeen.contains(field)) : "field \"" + field + "\" was added more than once during flush";
        this.fieldsSeen.add(field);
        return true;
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == FieldInfo.DocValuesType.NUMERIC || field.getNormType() == FieldInfo.DocValuesType.NUMERIC);
        this.writeFieldEntry(field, FieldInfo.DocValuesType.NUMERIC);
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        for (Number n : values) {
            long v = n == null ? 0L : n.longValue();
            minValue = Math.min(minValue, v);
            maxValue = Math.max(maxValue, v);
        }
        SimpleTextUtil.write((DataOutput)this.data, MINVALUE);
        SimpleTextUtil.write((DataOutput)this.data, Long.toString(minValue), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        BigInteger maxBig = BigInteger.valueOf(maxValue);
        BigInteger minBig = BigInteger.valueOf(minValue);
        BigInteger diffBig = maxBig.subtract(minBig);
        int maxBytesPerValue = diffBig.toString().length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesPerValue; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write((DataOutput)this.data, PATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        String patternString = sb.toString();
        DecimalFormat encoder = new DecimalFormat(patternString, new DecimalFormatSymbols(Locale.ROOT));
        int numDocsWritten = 0;
        for (Number n : values) {
            long value;
            long l = value = n == null ? 0L : n.longValue();
            assert (value >= minValue);
            BigInteger delta = BigInteger.valueOf(value).subtract(BigInteger.valueOf(minValue));
            String s = encoder.format(delta);
            assert (s.length() == patternString.length());
            SimpleTextUtil.write((DataOutput)this.data, s, this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            if (n == null) {
                SimpleTextUtil.write((DataOutput)this.data, "F", this.scratch);
            } else {
                SimpleTextUtil.write((DataOutput)this.data, "T", this.scratch);
            }
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            assert (++numDocsWritten <= this.numDocs);
        }
        assert (this.numDocs == numDocsWritten) : "numDocs=" + this.numDocs + " numDocsWritten=" + numDocsWritten;
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == FieldInfo.DocValuesType.BINARY);
        this.doAddBinary(field, values);
    }

    private void doAddBinary(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        int maxLength = 0;
        for (BytesRef value : values) {
            int length = value == null ? 0 : value.length;
            maxLength = Math.max(maxLength, length);
        }
        this.writeFieldEntry(field, FieldInfo.DocValuesType.BINARY);
        SimpleTextUtil.write((DataOutput)this.data, MAXLENGTH);
        SimpleTextUtil.write((DataOutput)this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        int maxBytesLength = Long.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesLength; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write((DataOutput)this.data, PATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int numDocsWritten = 0;
        for (BytesRef value : values) {
            int length = value == null ? 0 : value.length;
            SimpleTextUtil.write((DataOutput)this.data, LENGTH);
            SimpleTextUtil.write((DataOutput)this.data, encoder.format(length), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            if (value != null) {
                this.data.writeBytes(value.bytes, value.offset, value.length);
            }
            for (int i = length; i < maxLength; ++i) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            if (value == null) {
                SimpleTextUtil.write((DataOutput)this.data, "F", this.scratch);
            } else {
                SimpleTextUtil.write((DataOutput)this.data, "T", this.scratch);
            }
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            ++numDocsWritten;
        }
        assert (this.numDocs == numDocsWritten);
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED);
        this.writeFieldEntry(field, FieldInfo.DocValuesType.SORTED);
        int valueCount = 0;
        int maxLength = -1;
        for (BytesRef value : values) {
            maxLength = Math.max(maxLength, value.length);
            ++valueCount;
        }
        SimpleTextUtil.write((DataOutput)this.data, NUMVALUES);
        SimpleTextUtil.write((DataOutput)this.data, Integer.toString(valueCount), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        SimpleTextUtil.write((DataOutput)this.data, MAXLENGTH);
        SimpleTextUtil.write((DataOutput)this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        int maxBytesLength = Integer.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesLength; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write((DataOutput)this.data, PATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int maxOrdBytes = Long.toString((long)valueCount + 1L).length();
        sb.setLength(0);
        for (int i = 0; i < maxOrdBytes; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write((DataOutput)this.data, ORDPATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        DecimalFormat ordEncoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int valuesSeen = 0;
        for (BytesRef value : values) {
            SimpleTextUtil.write((DataOutput)this.data, LENGTH);
            SimpleTextUtil.write((DataOutput)this.data, encoder.format(value.length), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            this.data.writeBytes(value.bytes, value.offset, value.length);
            for (int i = value.length; i < maxLength; ++i) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            assert (++valuesSeen <= valueCount);
        }
        assert (valuesSeen == valueCount);
        for (Number ord : docToOrd) {
            SimpleTextUtil.write((DataOutput)this.data, ordEncoder.format(ord.longValue() + 1L), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
        }
    }

    public void addSortedNumericField(FieldInfo field, final Iterable<Number> docToValueCount, final Iterable<Number> values) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_NUMERIC);
        this.doAddBinary(field, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                final StringBuilder builder = new StringBuilder();
                final BytesRef scratch = new BytesRef();
                final Iterator counts = docToValueCount.iterator();
                final Iterator numbers = values.iterator();
                return new Iterator<BytesRef>(){

                    @Override
                    public boolean hasNext() {
                        return counts.hasNext();
                    }

                    @Override
                    public BytesRef next() {
                        builder.setLength(0);
                        long count = ((Number)counts.next()).longValue();
                        int i = 0;
                        while ((long)i < count) {
                            if (i > 0) {
                                builder.append(',');
                            }
                            builder.append(Long.toString(((Number)numbers.next()).longValue()));
                            ++i;
                        }
                        scratch.copyChars((CharSequence)builder);
                        return scratch;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        assert (this.fieldSeen(field.name));
        assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_SET);
        this.writeFieldEntry(field, FieldInfo.DocValuesType.SORTED_SET);
        long valueCount = 0L;
        int maxLength = 0;
        for (BytesRef value : values) {
            maxLength = Math.max(maxLength, value.length);
            ++valueCount;
        }
        SimpleTextUtil.write((DataOutput)this.data, NUMVALUES);
        SimpleTextUtil.write((DataOutput)this.data, Long.toString(valueCount), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        SimpleTextUtil.write((DataOutput)this.data, MAXLENGTH);
        SimpleTextUtil.write((DataOutput)this.data, Integer.toString(maxLength), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        int maxBytesLength = Integer.toString(maxLength).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxBytesLength; ++i) {
            sb.append('0');
        }
        SimpleTextUtil.write((DataOutput)this.data, PATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        DecimalFormat encoder = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.ROOT));
        int maxOrdListLength = 0;
        StringBuilder sb2 = new StringBuilder();
        Iterator<Number> ordStream = ords.iterator();
        for (Number n : docToOrdCount) {
            sb2.setLength(0);
            int count = n.intValue();
            for (int i = 0; i < count; ++i) {
                long ord = ordStream.next().longValue();
                if (sb2.length() > 0) {
                    sb2.append(",");
                }
                sb2.append(Long.toString(ord));
            }
            maxOrdListLength = Math.max(maxOrdListLength, sb2.length());
        }
        sb2.setLength(0);
        for (int i = 0; i < maxOrdListLength; ++i) {
            sb2.append('X');
        }
        SimpleTextUtil.write((DataOutput)this.data, ORDPATTERN);
        SimpleTextUtil.write((DataOutput)this.data, sb2.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        long valuesSeen = 0L;
        for (BytesRef value : values) {
            SimpleTextUtil.write((DataOutput)this.data, LENGTH);
            SimpleTextUtil.write((DataOutput)this.data, encoder.format(value.length), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            this.data.writeBytes(value.bytes, value.offset, value.length);
            for (int i = value.length; i < maxLength; ++i) {
                this.data.writeByte((byte)32);
            }
            SimpleTextUtil.writeNewline((DataOutput)this.data);
            assert (++valuesSeen <= valueCount);
        }
        assert (valuesSeen == valueCount);
        ordStream = ords.iterator();
        for (Number n : docToOrdCount) {
            sb2.setLength(0);
            int count = n.intValue();
            for (int i = 0; i < count; ++i) {
                long ord = ordStream.next().longValue();
                if (sb2.length() > 0) {
                    sb2.append(",");
                }
                sb2.append(Long.toString(ord));
            }
            int numPadding = maxOrdListLength - sb2.length();
            for (int i = 0; i < numPadding; ++i) {
                sb2.append(' ');
            }
            SimpleTextUtil.write((DataOutput)this.data, sb2.toString(), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)this.data);
        }
    }

    private void writeFieldEntry(FieldInfo field, FieldInfo.DocValuesType type) throws IOException {
        SimpleTextUtil.write((DataOutput)this.data, FIELD);
        SimpleTextUtil.write((DataOutput)this.data, field.name, this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
        SimpleTextUtil.write((DataOutput)this.data, TYPE);
        SimpleTextUtil.write((DataOutput)this.data, type.toString(), this.scratch);
        SimpleTextUtil.writeNewline((DataOutput)this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block6: {
            block7: {
                block5: {
                    if (this.data == null) break block6;
                    boolean success = false;
                    try {
                        assert (!this.fieldsSeen.isEmpty());
                        SimpleTextUtil.write((DataOutput)this.data, END);
                        SimpleTextUtil.writeNewline((DataOutput)this.data);
                        SimpleTextUtil.writeChecksum(this.data, this.scratch);
                        success = true;
                        if (!success) break block5;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{this.data});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
                        }
                        this.data = null;
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{this.data});
                    break block7;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            }
            this.data = null;
        }
    }
}

