/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.ParsePosition;
import org.python.icu.text.MeasureFormat;
import org.python.icu.text.NumberFormat;
import org.python.icu.util.CurrencyAmount;
import org.python.icu.util.ULocale;

class CurrencyFormat
extends MeasureFormat
implements Serializable {
    static final long serialVersionUID = -931679363692504634L;
    private NumberFormat fmt;

    public CurrencyFormat(ULocale locale) {
        this.fmt = NumberFormat.getCurrencyInstance(locale.toLocale());
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            CurrencyAmount currency = (CurrencyAmount)obj;
            this.fmt.setCurrency(currency.getCurrency());
            return this.fmt.format(currency.getNumber(), toAppendTo, pos);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid type: " + obj.getClass().getName());
        }
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.fmt.parseCurrency(source, pos);
    }
}

