/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetMappingsAction
extends TransportClusterInfoAction<GetMappingsRequest, GetMappingsResponse> {
    @Inject
    public TransportGetMappingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, "mappings/get", transportService, clusterService, threadPool);
    }

    @Override
    protected GetMappingsRequest newRequest() {
        return new GetMappingsRequest();
    }

    @Override
    protected GetMappingsResponse newResponse() {
        return new GetMappingsResponse();
    }

    @Override
    protected void doMasterOperation(GetMappingsRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetMappingsResponse> listener) throws ElasticsearchException {
        this.logger.trace("serving getMapping request based on version {}", state.version());
        ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> result = state.metaData().findMappings(concreteIndices, request.types());
        listener.onResponse(new GetMappingsResponse(result));
    }
}

