/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.action.admin.indices.IndicesAction;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.support.AbstractIndicesAdminClient;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalTransportIndicesAdminClient
extends AbstractIndicesAdminClient
implements IndicesAdminClient {
    private final TransportClientNodesService nodesService;
    private final ThreadPool threadPool;
    private final ImmutableMap<Action, TransportActionNodeProxy> actions;

    @Inject
    public InternalTransportIndicesAdminClient(Settings settings, TransportClientNodesService nodesService, TransportService transportService, ThreadPool threadPool, Map<String, GenericAction> actions) {
        this.nodesService = nodesService;
        this.threadPool = threadPool;
        MapBuilder actionsBuilder = new MapBuilder();
        for (GenericAction action : actions.values()) {
            if (!(action instanceof IndicesAction)) continue;
            actionsBuilder.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, final Request request) {
        final TransportActionNodeProxy proxy = this.actions.get(action);
        return (ActionFuture)this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<Response>>(){

            @Override
            public ActionFuture<Response> doWithNode(DiscoveryNode node) throws ElasticsearchException {
                return proxy.execute(node, request);
            }
        });
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> void execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, final Request request, ActionListener<Response> listener) {
        final TransportActionNodeProxy proxy = this.actions.get(action);
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<Response>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<Response> listener) throws ElasticsearchException {
                proxy.execute(node, request, listener);
            }
        }, listener);
    }
}

