/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.fs.AbstractFsBlobContainer;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.BlobStores;
import org.elasticsearch.common.io.FileSystemUtils;

public class FsImmutableBlobContainer
extends AbstractFsBlobContainer
implements ImmutableBlobContainer {
    public FsImmutableBlobContainer(FsBlobStore blobStore, BlobPath blobPath, File path) {
        super(blobStore, blobPath, path);
    }

    @Override
    public void writeBlob(final String blobName, final InputStream stream, final long sizeInBytes, final ImmutableBlobContainer.WriterListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(FsImmutableBlobContainer.this.path, blobName);
                boolean success = false;
                try {
                    try (RandomAccessFile raf = new RandomAccessFile(file, "rw");
                         InputStream is = stream;){
                        int bytesRead;
                        raf.setLength(0L);
                        long bytesWritten = 0L;
                        byte[] buffer = new byte[FsImmutableBlobContainer.this.blobStore.bufferSizeInBytes()];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            raf.write(buffer, 0, bytesRead);
                            bytesWritten += (long)bytesRead;
                        }
                        if (bytesWritten != sizeInBytes) {
                            throw new ElasticsearchIllegalStateException("[" + blobName + "]: wrote [" + bytesWritten + "], expected to write [" + sizeInBytes + "]");
                        }
                        raf.getFD().sync();
                        FileSystemUtils.syncFile(FsImmutableBlobContainer.this.path, true);
                    }
                    success = true;
                }
                catch (Throwable e) {
                    listener.onFailure(e);
                    FileSystemUtils.tryDeleteFile(file);
                }
                finally {
                    if (success) {
                        listener.onCompleted();
                    }
                }
            }
        });
    }

    @Override
    public void writeBlob(String blobName, InputStream is, long sizeInBytes) throws IOException {
        BlobStores.syncWriteBlob(this, blobName, is, sizeInBytes);
    }
}

