/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.ShardFilterCacheModule;
import org.elasticsearch.index.deletionpolicy.DeletionPolicyModule;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineModule;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldDataModule;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayModule;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.get.ShardGetModule;
import org.elasticsearch.index.indexing.ShardIndexingModule;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.merge.policy.MergePolicyModule;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerModule;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;
import org.elasticsearch.index.percolator.PercolatorShardModule;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.search.stats.ShardSearchModule;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShardCreationException;
import org.elasticsearch.index.shard.IndexShardModule;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotModule;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreModule;
import org.elasticsearch.index.suggest.SuggestShardModule;
import org.elasticsearch.index.termvectors.ShardTermVectorModule;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogModule;
import org.elasticsearch.index.translog.TranslogService;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ShardsPluginsModule;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndexService
extends AbstractIndexComponent
implements IndexService {
    private final Injector injector;
    private final Settings indexSettings;
    private final ThreadPool threadPool;
    private final PluginsService pluginsService;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final AnalysisService analysisService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final SimilarityService similarityService;
    private final IndexAliasesService aliasesService;
    private final IndexCache indexCache;
    private final IndexFieldDataService indexFieldData;
    private final IndexEngine indexEngine;
    private final IndexGateway indexGateway;
    private final IndexStore indexStore;
    private final IndexSettingsService settingsService;
    private volatile ImmutableMap<Integer, Injector> shardsInjectors = ImmutableMap.of();
    private volatile ImmutableMap<Integer, IndexShard> shards = ImmutableMap.of();
    private volatile boolean closed = false;

    @Inject
    public InternalIndexService(Injector injector, Index index, @IndexSettings Settings indexSettings, NodeEnvironment nodeEnv, ThreadPool threadPool, AnalysisService analysisService, MapperService mapperService, IndexQueryParserService queryParserService, SimilarityService similarityService, IndexAliasesService aliasesService, IndexCache indexCache, IndexEngine indexEngine, IndexGateway indexGateway, IndexStore indexStore, IndexSettingsService settingsService, IndexFieldDataService indexFieldData) {
        super(index, indexSettings);
        this.injector = injector;
        this.threadPool = threadPool;
        this.indexSettings = indexSettings;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.similarityService = similarityService;
        this.aliasesService = aliasesService;
        this.indexCache = indexCache;
        this.indexFieldData = indexFieldData;
        this.indexEngine = indexEngine;
        this.indexGateway = indexGateway;
        this.indexStore = indexStore;
        this.settingsService = settingsService;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesLifecycle = (InternalIndicesLifecycle)injector.getInstance(IndicesLifecycle.class);
        indexCache.filter().setIndexService(this);
        indexFieldData.setIndexService(this);
    }

    @Override
    public int numberOfShards() {
        return this.shards.size();
    }

    @Override
    public UnmodifiableIterator<IndexShard> iterator() {
        return ((ImmutableCollection)this.shards.values()).iterator();
    }

    @Override
    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Override
    public IndexShard shard(int shardId) {
        return this.shards.get(shardId);
    }

    @Override
    public IndexShard shardSafe(int shardId) throws IndexShardMissingException {
        IndexShard indexShard = this.shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return indexShard;
    }

    @Override
    public ImmutableSet<Integer> shardIds() {
        return this.shards.keySet();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public IndexGateway gateway() {
        return this.indexGateway;
    }

    @Override
    public IndexSettingsService settingsService() {
        return this.settingsService;
    }

    @Override
    public IndexStore store() {
        return this.indexStore;
    }

    @Override
    public IndexCache cache() {
        return this.indexCache;
    }

    @Override
    public IndexFieldDataService fieldData() {
        return this.indexFieldData;
    }

    @Override
    public AnalysisService analysisService() {
        return this.analysisService;
    }

    @Override
    public MapperService mapperService() {
        return this.mapperService;
    }

    @Override
    public IndexQueryParserService queryParserService() {
        return this.queryParserService;
    }

    @Override
    public SimilarityService similarityService() {
        return this.similarityService;
    }

    @Override
    public IndexAliasesService aliasesService() {
        return this.aliasesService;
    }

    @Override
    public IndexEngine engine() {
        return this.indexEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(final String reason, @Nullable Executor executor) {
        InternalIndexService internalIndexService = this;
        synchronized (internalIndexService) {
            this.closed = true;
        }
        ImmutableSet<Integer> shardIds = this.shardIds();
        final CountDownLatch latch = new CountDownLatch(shardIds.size());
        Iterator i$ = shardIds.iterator();
        while (i$.hasNext()) {
            final int shardId = (Integer)i$.next();
            executor = executor == null ? this.threadPool.generic() : executor;
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        InternalIndexService.this.removeShard(shardId, reason);
                    }
                    catch (Throwable e) {
                        InternalIndexService.this.logger.warn("failed to close shard", e, new Object[0]);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted closing index [{}]", e, this.index().name());
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Injector shardInjector(int shardId) throws ElasticsearchException {
        return this.shardsInjectors.get(shardId);
    }

    @Override
    public Injector shardInjectorSafe(int shardId) throws IndexShardMissingException {
        Injector shardInjector = this.shardInjector(shardId);
        if (shardInjector == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return shardInjector;
    }

    @Override
    public String indexUUID() {
        return this.indexSettings.get("index.uuid", "_na_");
    }

    @Override
    public synchronized IndexShard createShard(int sShardId) throws ElasticsearchException {
        Injector shardInjector;
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("Can't create shard [" + this.index.name() + "][" + sShardId + "], closed");
        }
        ShardId shardId = new ShardId(this.index, sShardId);
        if (this.shardsInjectors.containsKey(shardId.id())) {
            throw new IndexShardAlreadyExistsException(shardId + " already exists");
        }
        this.indicesLifecycle.beforeIndexShardCreated(shardId);
        this.logger.debug("creating shard_id [{}]", shardId.id());
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new ShardsPluginsModule(this.indexSettings, this.pluginsService));
        modules.add((Module)new IndexShardModule(this.indexSettings, shardId));
        modules.add((Module)new ShardIndexingModule());
        modules.add((Module)new ShardSearchModule());
        modules.add((Module)new ShardGetModule());
        modules.add((Module)new StoreModule(this.indexSettings, this.injector.getInstance(IndexStore.class)));
        modules.add((Module)new DeletionPolicyModule(this.indexSettings));
        modules.add((Module)new MergePolicyModule(this.indexSettings));
        modules.add((Module)new MergeSchedulerModule(this.indexSettings));
        modules.add((Module)new ShardFilterCacheModule());
        modules.add((Module)new ShardFieldDataModule());
        modules.add((Module)new TranslogModule(this.indexSettings));
        modules.add((Module)new EngineModule(this.indexSettings));
        modules.add((Module)new IndexShardGatewayModule(this.injector.getInstance(IndexGateway.class)));
        modules.add((Module)new PercolatorShardModule());
        modules.add((Module)new ShardTermVectorModule());
        modules.add((Module)new IndexShardSnapshotModule());
        modules.add((Module)new SuggestShardModule());
        try {
            shardInjector = modules.createChildInjector(this.injector);
        }
        catch (CreationException e) {
            throw new IndexShardCreationException(shardId, Injectors.getFirstErrorFailure(e));
        }
        catch (Throwable e) {
            throw new IndexShardCreationException(shardId, e);
        }
        this.shardsInjectors = MapBuilder.newMapBuilder(this.shardsInjectors).put(shardId.id(), shardInjector).immutableMap();
        IndexShard indexShard = shardInjector.getInstance(IndexShard.class);
        this.indicesLifecycle.indexShardStateChanged(indexShard, null, "shard created");
        this.indicesLifecycle.afterIndexShardCreated(indexShard);
        this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), indexShard).immutableMap();
        return indexShard;
    }

    @Override
    public synchronized void removeShard(int shardId, String reason) throws ElasticsearchException {
        ShardId sId = new ShardId(this.index, shardId);
        HashMap<Integer, Injector> tmpShardInjectors = Maps.newHashMap(this.shardsInjectors);
        Injector shardInjector = (Injector)tmpShardInjectors.remove(shardId);
        if (shardInjector == null) {
            return;
        }
        this.shardsInjectors = ImmutableMap.copyOf(tmpShardInjectors);
        HashMap<Integer, IndexShard> tmpShardsMap = Maps.newHashMap(this.shards);
        IndexShard indexShard = (IndexShard)tmpShardsMap.remove(shardId);
        this.shards = ImmutableMap.copyOf(tmpShardsMap);
        this.indicesLifecycle.beforeIndexShardClosed(sId, indexShard);
        for (Class<? extends CloseableIndexComponent> closeable : this.pluginsService.shardServices()) {
            try {
                shardInjector.getInstance(closeable).close();
            }
            catch (Throwable e) {
                this.logger.debug("failed to clean plugin shard service [{}]", e, closeable);
            }
        }
        try {
            shardInjector.getInstance(TranslogService.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close translog service", e, new Object[0]);
        }
        if (indexShard != null) {
            try {
                ((InternalIndexShard)indexShard).close(reason);
            }
            catch (Throwable e) {
                this.logger.debug("failed to close index shard", e, new Object[0]);
            }
        }
        try {
            shardInjector.getInstance(Engine.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close engine", e, new Object[0]);
        }
        try {
            shardInjector.getInstance(MergeSchedulerProvider.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close merge policy scheduler", e, new Object[0]);
        }
        try {
            shardInjector.getInstance(MergePolicyProvider.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close merge policy provider", e, new Object[0]);
        }
        try {
            shardInjector.getInstance(IndexShardGatewayService.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close index shard gateway", e, new Object[0]);
        }
        try {
            shardInjector.getInstance(Translog.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close translog", e, new Object[0]);
        }
        try {
            shardInjector.getInstance(PercolatorQueriesRegistry.class).close();
        }
        catch (Throwable e) {
            this.logger.debug("failed to close PercolatorQueriesRegistry", e, new Object[0]);
        }
        this.indicesLifecycle.afterIndexShardClosed(sId);
        Store store = shardInjector.getInstance(Store.class);
        try {
            store.close();
        }
        catch (Throwable e) {
            this.logger.warn("failed to close store on shard deletion", e, new Object[0]);
        }
        Injectors.close(this.injector);
    }
}

