/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.SimilarityLookupService;

public class SimilarityService
extends AbstractIndexComponent {
    private final SimilarityLookupService similarityLookupService;
    private final MapperService mapperService;
    private final Similarity perFieldSimilarity;

    public SimilarityService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public SimilarityService(Index index, Settings settings) {
        this(index, settings, new SimilarityLookupService(index, settings), null);
    }

    @Inject
    public SimilarityService(Index index, @IndexSettings Settings indexSettings, SimilarityLookupService similarityLookupService, MapperService mapperService) {
        super(index, indexSettings);
        this.similarityLookupService = similarityLookupService;
        this.mapperService = mapperService;
        Similarity defaultSimilarity = similarityLookupService.similarity("default").get();
        Similarity baseSimilarity = similarityLookupService.similarity("base") != null ? similarityLookupService.similarity("base").get() : defaultSimilarity;
        this.perFieldSimilarity = mapperService != null ? new PerFieldSimilarity(defaultSimilarity, baseSimilarity, mapperService) : defaultSimilarity;
    }

    public Similarity similarity() {
        return this.perFieldSimilarity;
    }

    public SimilarityLookupService similarityLookupService() {
        return this.similarityLookupService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final Similarity baseSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, Similarity baseSimilarity, MapperService mapperService) {
            this.defaultSimilarity = defaultSimilarity;
            this.baseSimilarity = baseSimilarity;
            this.mapperService = mapperService;
        }

        public float coord(int overlap, int maxOverlap) {
            return this.baseSimilarity.coord(overlap, maxOverlap);
        }

        public float queryNorm(float valueForNormalization) {
            return this.baseSimilarity.queryNorm(valueForNormalization);
        }

        public Similarity get(String name) {
            FieldMapper mapper = this.mapperService.smartNameFieldMapper(name);
            return mapper != null && mapper.similarity() != null ? mapper.similarity().get() : this.defaultSimilarity;
        }
    }
}

