/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.termvectors;

import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;

public class ShardTermVectorService
extends AbstractIndexShardComponent {
    private IndexShard indexShard;
    private MapperService mapperService;

    @Inject
    public ShardTermVectorService(ShardId shardId, @IndexSettings Settings indexSettings, MapperService mapperService) {
        super(shardId, indexSettings);
    }

    public ShardTermVectorService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    public TermVectorResponse getTermVector(TermVectorRequest request) {
        Engine.Searcher searcher = this.indexShard.acquireSearcher("term_vector");
        IndexReader topLevelReader = searcher.reader();
        TermVectorResponse termVectorResponse = new TermVectorResponse(request.index(), request.type(), request.id());
        Term uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()));
        try {
            Fields topLevelFields = MultiFields.getFields((IndexReader)topLevelReader);
            Versions.DocIdAndVersion docIdAndVersion = Versions.loadDocIdAndVersion(topLevelReader, uidTerm);
            if (docIdAndVersion != null) {
                Fields termVectorsByField = docIdAndVersion.context.reader().getTermVectors(docIdAndVersion.docId);
                termVectorResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields);
                termVectorResponse.setExists(true);
                termVectorResponse.setDocVersion(docIdAndVersion.version);
            } else {
                termVectorResponse.setExists(false);
            }
        }
        catch (Throwable ex) {
            throw new ElasticsearchException("failed to execute term vector request", ex);
        }
        finally {
            searcher.close();
        }
        return termVectorResponse;
    }
}

