/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.groovy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.DateTimeUtils;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.Instant;
import org.elasticsearch.common.settings.Settings;

public class GroovySandboxExpressionChecker
implements SecureASTCustomizer.ExpressionChecker {
    public static String GROOVY_SANDBOX_METHOD_BLACKLIST = "script.groovy.sandbox.method_blacklist";
    public static String GROOVY_SANDBOX_PACKAGE_WHITELIST = "script.groovy.sandbox.package_whitelist";
    public static String GROOVY_SANDBOX_CLASS_WHITELIST = "script.groovy.sandbox.class_whitelist";
    public static String GROOVY_SCRIPT_SANDBOX_RECEIVER_WHITELIST = "script.groovy.sandbox.receiver_whitelist";
    private final Set<String> methodBlacklist;
    private final Set<String> packageWhitelist;
    private final Set<String> classWhitelist;
    public static String[] defaultMethodBlacklist = new String[]{"getClass", "wait", "notify", "notifyAll", "finalize"};
    public static String[] defaultPackageWhitelist = new String[]{"java.util", "java.lang", "org.elasticsearch.common.joda.time"};
    public static String[] defaultClassConstructionWhitelist = new String[]{Date.class.getName(), Map.class.getName(), List.class.getName(), Set.class.getName(), ArrayList.class.getName(), Arrays.class.getName(), HashMap.class.getName(), HashSet.class.getName(), UUID.class.getName(), BigDecimal.class.getName(), DateTime.class.getName(), DateTimeZone.class.getName()};
    private static final String[] defaultReceiverWhitelist = new String[]{Math.class.getName(), Integer.class.getName(), "[I", "[[I", "[[[I", Float.class.getName(), "[F", "[[F", "[[[F", Double.class.getName(), "[D", "[[D", "[[[D", Long.class.getName(), "[J", "[[J", "[[[J", Short.class.getName(), "[S", "[[S", "[[[S", Character.class.getName(), "[C", "[[C", "[[[C", Byte.class.getName(), "[B", "[[B", "[[[B", Boolean.class.getName(), "[Z", "[[Z", "[[[Z", BigDecimal.class.getName(), Arrays.class.getName(), Date.class.getName(), List.class.getName(), Map.class.getName(), Set.class.getName(), Object.class.getName(), DateTime.class.getName(), DateTimeUtils.class.getName(), DateTimeZone.class.getName(), Instant.class.getName()};

    public GroovySandboxExpressionChecker(Settings settings) {
        this.methodBlacklist = ImmutableSet.copyOf(settings.getAsArray(GROOVY_SANDBOX_METHOD_BLACKLIST, defaultMethodBlacklist, true));
        this.packageWhitelist = ImmutableSet.copyOf(settings.getAsArray(GROOVY_SANDBOX_PACKAGE_WHITELIST, defaultPackageWhitelist, true));
        this.classWhitelist = ImmutableSet.copyOf(settings.getAsArray(GROOVY_SANDBOX_CLASS_WHITELIST, defaultClassConstructionWhitelist, true));
    }

    public boolean isAuthorized(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)expression;
            String methodName = mce.getMethodAsString();
            if (this.methodBlacklist.contains(methodName)) {
                return false;
            }
            if (methodName == null && mce.getMethod() instanceof GStringExpression) {
                return false;
            }
        } else if (expression instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)expression;
            ClassNode type = cce.getType();
            if (!this.packageWhitelist.contains(type.getPackageName())) {
                return false;
            }
            if (!this.classWhitelist.contains(type.getName())) {
                return false;
            }
        }
        return true;
    }

    public static SecureASTCustomizer getSecureASTCustomizer(Settings settings) {
        SecureASTCustomizer scz = new SecureASTCustomizer();
        scz.setClosuresAllowed(true);
        scz.setMethodDefinitionAllowed(false);
        ArrayList<String> importWhitelist = new ArrayList<String>();
        importWhitelist.addAll(ImmutableSet.copyOf(defaultClassConstructionWhitelist));
        scz.setImportsWhitelist(importWhitelist);
        scz.setPackageAllowed(false);
        String[] receiverWhitelist = settings.getAsArray(GROOVY_SCRIPT_SANDBOX_RECEIVER_WHITELIST, defaultReceiverWhitelist, true);
        scz.setReceiversWhiteList(Lists.newArrayList(receiverWhitelist));
        scz.addExpressionCheckers(new SecureASTCustomizer.ExpressionChecker[]{new GroovySandboxExpressionChecker(settings)});
        return scz;
    }
}

