/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParserMapper;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class SignificantTermsHeuristicModule
extends AbstractModule {
    private List<Class<? extends SignificanceHeuristicParser>> parsers = Lists.newArrayList();
    private List<SignificanceHeuristicStreams.Stream> streams = Lists.newArrayList();

    public SignificantTermsHeuristicModule() {
        this.registerHeuristic(JLHScore.JLHScoreParser.class, JLHScore.STREAM);
        this.registerHeuristic(MutualInformation.MutualInformationParser.class, MutualInformation.STREAM);
    }

    public void registerHeuristic(Class<? extends SignificanceHeuristicParser> parser, SignificanceHeuristicStreams.Stream stream) {
        this.parsers.add(parser);
        this.streams.add(stream);
    }

    @Override
    protected void configure() {
        Multibinder<SignificanceHeuristicParser> parserMapBinder = Multibinder.newSetBinder(this.binder(), SignificanceHeuristicParser.class);
        for (Class<? extends SignificanceHeuristicParser> clazz : this.parsers) {
            parserMapBinder.addBinding().to(clazz);
        }
        this.bind(SignificanceHeuristicParserMapper.class);
        for (SignificanceHeuristicStreams.Stream stream : this.streams) {
            SignificanceHeuristicStreams.registerStream(stream, stream.getName());
        }
    }
}

