/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.support;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class IncludeExclude {
    private final Matcher include;
    private final Matcher exclude;
    private final CharsRef scratch = new CharsRef();

    public IncludeExclude(Pattern include, Pattern exclude) {
        assert (include != null || exclude != null) : "include & exclude cannot both be null";
        this.include = include != null ? include.matcher("") : null;
        this.exclude = exclude != null ? exclude.matcher("") : null;
    }

    public boolean accept(BytesRef value) {
        UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)this.scratch);
        if (this.include == null) {
            return !this.exclude.reset((CharSequence)this.scratch).matches();
        }
        if (!this.include.reset((CharSequence)this.scratch).matches()) {
            return false;
        }
        if (this.exclude == null) {
            return true;
        }
        return !this.exclude.reset((CharSequence)this.scratch).matches();
    }

    public LongBitSet acceptedGlobalOrdinals(BytesValues.WithOrdinals globalOrdinals, ValuesSource.Bytes.WithOrdinals valueSource) {
        TermsEnum globalTermsEnum = valueSource.globalBytesValues().getTermsEnum();
        LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getMaxOrd());
        try {
            BytesRef term = globalTermsEnum.next();
            while (term != null) {
                if (this.accept(term)) {
                    acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                }
                term = globalTermsEnum.next();
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        return acceptedGlobalOrdinals;
    }

    public static class Parser {
        private final String aggName;
        private final InternalAggregation.Type aggType;
        private final SearchContext context;
        String include = null;
        int includeFlags = 0;
        String exclude = null;
        int excludeFlags = 0;

        public Parser(String aggName, InternalAggregation.Type aggType, SearchContext context) {
            this.aggName = aggName;
            this.aggType = aggType;
            this.context = context;
        }

        public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("include".equals(currentFieldName)) {
                    this.include = parser.text();
                } else if ("exclude".equals(currentFieldName)) {
                    this.exclude = parser.text();
                } else {
                    return false;
                }
                return true;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                this.include = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            this.includeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        this.includeFlags = parser.intValue();
                    }
                } else if ("exclude".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                this.exclude = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            this.excludeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        this.excludeFlags = parser.intValue();
                    }
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }

        public IncludeExclude includeExclude() {
            if (this.include == null && this.exclude == null) {
                return null;
            }
            Pattern includePattern = this.include != null ? Pattern.compile(this.include, this.includeFlags) : null;
            Pattern excludePattern = this.exclude != null ? Pattern.compile(this.exclude, this.excludeFlags) : null;
            return new IncludeExclude(includePattern, excludePattern);
        }
    }
}

