/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class StatsAggegator
extends NumericMetricsAggregator.MultiValue {
    private final ValuesSource.Numeric valuesSource;
    private DoubleValues values;
    private LongArray counts;
    private DoubleArray sums;
    private DoubleArray mins;
    private DoubleArray maxes;

    public StatsAggegator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.counts = this.bigArrays.newLongArray(initialSize, true);
            this.sums = this.bigArrays.newDoubleArray(initialSize, true);
            this.mins = this.bigArrays.newDoubleArray(initialSize, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = this.bigArrays.newDoubleArray(initialSize, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        if (owningBucketOrdinal >= this.counts.size()) {
            long from = this.counts.size();
            long overSize = BigArrays.overSize(owningBucketOrdinal + 1L);
            this.counts = this.bigArrays.resize(this.counts, overSize);
            this.sums = this.bigArrays.resize(this.sums, overSize);
            this.mins = this.bigArrays.resize(this.mins, overSize);
            this.maxes = this.bigArrays.resize(this.maxes, overSize);
            this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
            this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
        }
        int valuesCount = this.values.setDocument(doc);
        this.counts.increment(owningBucketOrdinal, valuesCount);
        double sum = 0.0;
        double min = this.mins.get(owningBucketOrdinal);
        double max = this.maxes.get(owningBucketOrdinal);
        for (int i = 0; i < valuesCount; ++i) {
            double value = this.values.nextValue();
            sum += value;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        this.sums.increment(owningBucketOrdinal, sum);
        this.mins.set(owningBucketOrdinal, min);
        this.maxes.set(owningBucketOrdinal, max);
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        switch (InternalStats.Metrics.resolve(name)) {
            case count: {
                return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.valuesSource == null ? 0.0 : this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.valuesSource == null ? Double.POSITIVE_INFINITY : this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.valuesSource == null ? Double.NEGATIVE_INFINITY : this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
        }
        throw new ElasticsearchIllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalStats(this.name, this.counts.get(owningBucketOrdinal), this.sums.get(owningBucketOrdinal), this.mins.get(owningBucketOrdinal), this.maxes.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, InternalStats.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new StatsAggegator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new StatsAggegator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

