/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueParser;

public class ValuesSourceConfig<VS extends ValuesSource> {
    final Class<VS> valueSourceType;
    FieldContext fieldContext;
    SearchScript script;
    ValueType scriptValueType;
    boolean unmapped = false;
    boolean ensureUnique = false;
    boolean ensureSorted = false;
    String formatPattern;
    ValueFormat format;

    public ValuesSourceConfig(Class<VS> valueSourceType) {
        this.valueSourceType = valueSourceType;
    }

    public Class<VS> valueSourceType() {
        return this.valueSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public SearchScript script() {
        return this.script;
    }

    public boolean unmapped() {
        return this.unmapped;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValuesSourceConfig<VS> fieldContext(FieldContext fieldContext) {
        this.fieldContext = fieldContext;
        return this;
    }

    public ValuesSourceConfig<VS> script(SearchScript script) {
        this.script = script;
        return this;
    }

    public ValuesSourceConfig<VS> unmapped(boolean unmapped) {
        this.unmapped = unmapped;
        return this;
    }

    public ValueFormat format() {
        return this.format;
    }

    public ValueFormatter formatter() {
        return this.format != null ? this.format.formatter() : null;
    }

    public ValueParser parser() {
        return this.format != null ? this.format.parser() : null;
    }
}

