/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.common.lucene.MultiCollector;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.dfs.CachedDfSource;
import org.elasticsearch.search.internal.DocIdSetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private final IndexSearcher in;
    private final SearchContext searchContext;
    private CachedDfSource dfSource;
    private List<Collector> queryCollectors;
    private Stage currentState = Stage.NA;
    private boolean enableMainDocIdSetCollector;
    private DocIdSetCollector mainDocIdSetCollector;

    public ContextIndexSearcher(SearchContext searchContext, Engine.Searcher searcher) {
        super(searcher.reader());
        this.in = searcher.searcher();
        this.searchContext = searchContext;
        this.setSimilarity(searcher.searcher().getSimilarity());
    }

    @Override
    public void close() {
        Releasables.close(this.mainDocIdSetCollector);
    }

    public void dfSource(CachedDfSource dfSource) {
        this.dfSource = dfSource;
    }

    public void addMainQueryCollector(Collector collector) {
        if (this.queryCollectors == null) {
            this.queryCollectors = new ArrayList<Collector>();
        }
        this.queryCollectors.add(collector);
    }

    public DocIdSetCollector mainDocIdSetCollector() {
        return this.mainDocIdSetCollector;
    }

    public void enableMainDocIdSetCollector() {
        this.enableMainDocIdSetCollector = true;
    }

    public void inStage(Stage stage) {
        this.currentState = stage;
    }

    public void finishStage(Stage stage) {
        assert (this.currentState == stage) : "Expected stage " + (Object)((Object)stage) + " but was stage " + (Object)((Object)this.currentState);
        this.currentState = Stage.NA;
    }

    public Query rewrite(Query original) throws IOException {
        if (original == this.searchContext.query() || original == this.searchContext.parsedQuery().query()) {
            if (this.searchContext.queryRewritten()) {
                return this.searchContext.query();
            }
            Query rewriteQuery = this.in.rewrite(original);
            this.searchContext.updateRewriteQuery(rewriteQuery);
            return rewriteQuery;
        }
        return this.in.rewrite(original);
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        try {
            if (this.dfSource != null && (query == this.searchContext.query() || query == this.searchContext.parsedQuery().query())) {
                return this.dfSource.createNormalizedWeight(query);
            }
            return this.in.createNormalizedWeight(query);
        }
        catch (Throwable t) {
            this.searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(List<AtomicReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        if (this.searchContext.timeoutInMillis() != -1L) {
            collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), this.searchContext.timeoutInMillis());
        }
        if (this.currentState == Stage.MAIN_QUERY) {
            if (this.enableMainDocIdSetCollector) {
                this.mainDocIdSetCollector = new DocIdSetCollector(this.searchContext.docSetCache(), collector);
                collector = this.mainDocIdSetCollector;
            }
            if (this.searchContext.parsedPostFilter() != null) {
                collector = new FilteredCollector(collector, this.searchContext.parsedPostFilter().filter());
            }
            if (this.queryCollectors != null && !this.queryCollectors.isEmpty()) {
                collector = new MultiCollector(collector, this.queryCollectors.toArray(new Collector[this.queryCollectors.size()]));
            }
            if (this.searchContext.minimumScore() != null) {
                collector = new MinimumScoreCollector(collector, this.searchContext.minimumScore().floatValue());
            }
        }
        try {
            if (this.searchContext.timeoutInMillis() != -1L) {
                try {
                    super.search(leaves, weight, collector);
                }
                catch (TimeLimitingCollector.TimeExceededException e) {
                    this.searchContext.queryResult().searchTimedOut(true);
                }
            } else {
                super.search(leaves, weight, collector);
            }
            if (this.currentState == Stage.MAIN_QUERY) {
                if (this.enableMainDocIdSetCollector) {
                    this.enableMainDocIdSetCollector = false;
                    this.mainDocIdSetCollector.postCollection();
                }
                if (this.queryCollectors != null && !this.queryCollectors.isEmpty()) {
                    for (Collector queryCollector : this.queryCollectors) {
                        if (!(queryCollector instanceof XCollector)) continue;
                        ((XCollector)queryCollector).postCollection();
                    }
                }
            }
        }
        finally {
            this.searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Explanation explain(Query query, int doc) throws IOException {
        try {
            if (this.searchContext.aliasFilter() == null) {
                Explanation explanation = super.explain(query, doc);
                return explanation;
            }
            XFilteredQuery filteredQuery = new XFilteredQuery(query, this.searchContext.aliasFilter());
            Explanation explanation = super.explain((Query)filteredQuery, doc);
            return explanation;
        }
        finally {
            this.searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }

    public static enum Stage {
        NA,
        MAIN_QUERY;

    }
}

