/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.components.TraversalListener;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.CompositeExecutionLog;
import fitnesse.reporting.InteractiveFormatter;
import fitnesse.reporting.PageInProgressFormatter;
import fitnesse.reporting.SuiteHtmlFormatter;
import fitnesse.reporting.TestTextFormatter;
import fitnesse.reporting.history.SuiteHistoryFormatter;
import fitnesse.reporting.history.SuiteXmlReformatter;
import fitnesse.reporting.history.TestXmlFormatter;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiImportingTraverser;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.PagesByTestSystem;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestResponder
extends ChunkingResponder
implements SecureResponder {
    private final Logger LOG = Logger.getLogger(TestResponder.class.getName());
    public static final String TEST_RESULT_FILE_DATE_PATTERN = "yyyyMMddHHmmss";
    private static final String NOT_FILTER_ARG = "excludeSuiteFilter";
    private static final String AND_FILTER_ARG = "runTestsMatchingAllTags";
    private static final String OR_FILTER_ARG_1 = "runTestsMatchingAnyTag";
    private static final String OR_FILTER_ARG_2 = "suiteFilter";
    private final WikiImporter wikiImporter;
    private SuiteHistoryFormatter suiteHistoryFormatter;
    private PageData data;
    private BaseFormatter mainFormatter;
    private volatile boolean isClosed = false;
    private boolean debug = false;
    private boolean remoteDebug = false;
    private boolean includeHtml = true;
    int exitCode;
    private CompositeExecutionLog log;

    public TestResponder() {
        this(new WikiImporter());
    }

    public TestResponder(WikiImporter wikiImporter) {
        this.wikiImporter = wikiImporter;
    }

    private boolean isInteractive() {
        return this.mainFormatter instanceof InteractiveFormatter;
    }

    @Override
    protected void doSending() throws Exception {
        this.debug |= this.request.hasInput("debug");
        this.remoteDebug |= this.request.hasInput("remote_debug");
        this.includeHtml |= this.request.hasInput("includehtml");
        this.data = this.page.getData();
        this.log = new CompositeExecutionLog(this.page);
        this.createMainFormatter();
        if (this.isInteractive()) {
            this.makeHtml().render(this.response.getWriter());
        } else {
            this.doExecuteTests();
        }
        this.closeHtmlResponse(this.exitCode);
    }

    public void doExecuteTests() {
        if (WikiImportProperty.isImported(this.data)) {
            this.importWikiPages();
        }
        try {
            this.performExecution();
        }
        catch (Exception e) {
            this.mainFormatter.errorOccurred(e);
            this.LOG.log(Level.WARNING, "error registered in test system", e);
        }
        this.exitCode = this.mainFormatter.getErrorCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importWikiPages() {
        if (this.response.isXmlFormat() || !WikiImportProperty.isAutoUpdated(this.data != null ? this.data : this.page.getData())) {
            return;
        }
        try {
            this.addToResponse("<span class=\"meta\">Updating imported content...</span><span class=\"meta\">");
            new WikiImportingTraverser(this.wikiImporter, this.page).traverse(new TraversalListener<Object>(){

                @Override
                public void process(Object pageOrError) {
                    if (pageOrError instanceof WikiImportingTraverser.ImportError) {
                        WikiImportingTraverser.ImportError error = (WikiImportingTraverser.ImportError)pageOrError;
                        TestResponder.this.addToResponse(" " + error.toString() + ".");
                    }
                }
            });
            this.addToResponse(" Done.");
            this.data = this.page.getData();
        }
        catch (IOException e) {
            this.addToResponse(" Import failed: " + e.toString() + ".");
        }
        finally {
            this.addToResponse("</span>");
        }
    }

    private HtmlPage makeHtml() {
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath();
        String fullPathName = PathParser.render(fullPath);
        HtmlPage htmlPage = this.context.pageFactory.newPage();
        htmlPage.setTitle(this.getTitle() + ": " + fullPathName);
        htmlPage.setPageTitle(new PageTitle(this.getTitle(), fullPath, this.data.getAttribute("Suites")));
        htmlPage.setNavTemplate("testNav.vm");
        htmlPage.put("actions", new WikiPageActions(this.page));
        htmlPage.setMainTemplate(this.mainTemplate());
        htmlPage.put("testExecutor", new TestExecutor());
        htmlPage.setFooterTemplate("wikiFooter.vm");
        htmlPage.put("headerContent", new WikiPageHeaderRenderer());
        htmlPage.put("footerContent", new WikiPageFooterRenderer());
        htmlPage.setErrorNavTemplate("errorNavigator");
        htmlPage.put("errorNavOnDocumentReady", false);
        htmlPage.put("multipleTestsRun", this.isMultipleTestsRun());
        WikiImportingResponder.handleImportProperties(htmlPage, this.page);
        return htmlPage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private boolean isMultipleTestsRun() {
        return PageType.fromWikiPage(this.page) == PageType.SUITE;
    }

    protected void addFormatters(MultipleTestsRunner runner) {
        runner.addTestSystemListener(this.mainFormatter);
        if (!this.request.hasInput("nohistory")) {
            runner.addTestSystemListener(this.getSuiteHistoryFormatter());
        }
        runner.addTestSystemListener(this.newTestInProgressFormatter());
        if (this.context.testSystemListener != null) {
            runner.addTestSystemListener(this.context.testSystemListener);
        }
    }

    private void createMainFormatter() {
        this.mainFormatter = this.response.isXmlFormat() ? this.newXmlFormatter() : (this.response.isTextFormat() ? this.newTextFormatter() : this.newHtmlFormatter());
    }

    protected String getTitle() {
        return "Test Results";
    }

    protected String mainTemplate() {
        return "testPage";
    }

    BaseFormatter newXmlFormatter() {
        SuiteXmlReformatter xmlFormatter = new SuiteXmlReformatter(this.context, this.page, this.response.getWriter(), this.getSuiteHistoryFormatter());
        if (this.includeHtml) {
            xmlFormatter.includeHtml();
        }
        if (!this.isMultipleTestsRun()) {
            xmlFormatter.includeInstructions();
        }
        return xmlFormatter;
    }

    BaseFormatter newTextFormatter() {
        return new TestTextFormatter(this.response);
    }

    BaseFormatter newHtmlFormatter() {
        return new SuiteHtmlFormatter(this.context, this.page, this.log){

            @Override
            protected void writeData(String output) {
                TestResponder.this.addToResponse(output);
            }
        };
    }

    protected TestSystemListener newTestInProgressFormatter() {
        return new PageInProgressFormatter(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performExecution() throws IOException, InterruptedException {
        SuiteFilter filter = TestResponder.createSuiteFilter(this.request, this.page.getPageCrawler().getFullPath().toString());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(this.page, filter, this.root);
        MultipleTestsRunner runner = this.newMultipleTestsRunner(suiteTestFinder.getAllPagesToRunForThisSuite());
        try {
            runner.executeTestPages();
        }
        finally {
            this.log.publish(this.context.pageFactory);
        }
    }

    protected MultipleTestsRunner newMultipleTestsRunner(List<WikiPage> pages) {
        PagesByTestSystem pagesByTestSystem = new PagesByTestSystem(pages, this.context.root);
        MultipleTestsRunner runner = new MultipleTestsRunner(pagesByTestSystem, this.context.runningTestingTracker, this.context.testSystemFactory, this.context.variableSource);
        runner.setRunInProcess(this.debug);
        runner.setEnableRemoteDebug(this.remoteDebug);
        runner.addExecutionLogListener(this.log);
        this.addFormatters(runner);
        return runner;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    public void addToResponse(String output) {
        if (!this.isClosed()) {
            this.response.add(output);
        }
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }

    synchronized void setClosed() {
        this.isClosed = true;
    }

    void closeHtmlResponse(int exitCode) {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.closeChunks();
            this.response.addTrailingHeader("Exit-Code", String.valueOf(exitCode));
            this.response.closeTrailer();
            this.response.close();
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public static SuiteFilter createSuiteFilter(Request request, String suitePath) {
        return new SuiteFilter(TestResponder.getOrTagFilter(request), TestResponder.getNotSuiteFilter(request), TestResponder.getAndTagFilters(request), TestResponder.getSuiteFirstTest(request, suitePath));
    }

    private static String getOrTagFilter(Request request) {
        return request != null ? TestResponder.getOrFilterString(request) : null;
    }

    private static String getOrFilterString(Request request) {
        String orFilterString = null;
        orFilterString = request.getInput(OR_FILTER_ARG_1) != null ? (String)request.getInput(OR_FILTER_ARG_1) : (String)request.getInput(OR_FILTER_ARG_2);
        return orFilterString;
    }

    private static String getNotSuiteFilter(Request request) {
        return request != null ? (String)request.getInput(NOT_FILTER_ARG) : null;
    }

    private static String getAndTagFilters(Request request) {
        return request != null ? (String)request.getInput(AND_FILTER_ARG) : null;
    }

    private static String getSuiteFirstTest(Request request, String suiteName) {
        String startTest = null;
        if (request != null) {
            startTest = (String)request.getInput("firstTest");
        }
        if (startTest != null && startTest.indexOf(suiteName) != 0) {
            startTest = suiteName + "." + startTest;
        }
        return startTest;
    }

    public static String makePageHistoryFileName(FitNesseContext context, WikiPage page, TestSummary counts, long time) {
        return String.format("%s/%s/%s", context.getTestHistoryDirectory(), page.getPageCrawler().getFullPath().toString(), TestResponder.makeResultFileName(counts, time));
    }

    public static String makeResultFileName(TestSummary summary, long time) {
        SimpleDateFormat format = new SimpleDateFormat(TEST_RESULT_FILE_DATE_PATTERN);
        String datePart = format.format(new Date(time));
        return String.format("%s_%d_%d_%d_%d.xml", datePart, summary.getRight(), summary.getWrong(), summary.getIgnores(), summary.getExceptions());
    }

    public SuiteHistoryFormatter getSuiteHistoryFormatter() {
        if (this.suiteHistoryFormatter == null) {
            HistoryWriterFactory source = new HistoryWriterFactory();
            this.suiteHistoryFormatter = new SuiteHistoryFormatter(this.context, this.page, source);
        }
        return this.suiteHistoryFormatter;
    }

    public static class HistoryWriterFactory
    implements TestXmlFormatter.WriterFactory {
        @Override
        public Writer getWriter(FitNesseContext context, WikiPage page, TestSummary counts, long time) throws IOException {
            File resultPath = new File(TestResponder.makePageHistoryFileName(context, page, counts, time));
            File resultDirectory = new File(resultPath.getParent());
            if (!resultDirectory.exists()) {
                resultDirectory.mkdirs();
            }
            File resultFile = new File(resultDirectory, resultPath.getName());
            return new PrintWriter(resultFile, "UTF-8");
        }
    }

    public class TestExecutor {
        public void execute() {
            TestResponder.this.doExecuteTests();
        }
    }

    public class WikiPageFooterRenderer {
        public String render() {
            return WikiPageUtil.getFooterPageHtml(TestResponder.this.page);
        }
    }

    public class WikiPageHeaderRenderer {
        public String render() {
            return WikiPageUtil.getHeaderPageHtml(TestResponder.this.page);
        }
    }
}

