/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.responders.ErrorResponder;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.velocity.VelocityContext;
import util.FileUtil;

public class PageHistoryResponder
implements SecureResponder {
    private File resultsDirectory;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleResponse response;
    private PageHistory pageHistory;
    private HtmlPage page;
    private FitNesseContext context;
    private PageTitle pageTitle;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.prepareResponse(request);
        if (request.hasInput("resultDate")) {
            return this.tryToMakeTestExecutionReport(request);
        }
        if (this.formatIsXML(request)) {
            return this.makePageHistoryXmlResponse(request);
        }
        return this.makePageHistoryResponse(request);
    }

    private Response makePageHistoryResponse(Request request) {
        this.page.setTitle("Page History");
        this.page.put("pageHistory", this.pageHistory);
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.setMainTemplate("pageHistory");
        return this.makeResponse();
    }

    private Response makePageHistoryXmlResponse(Request request) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("pageHistory", this.pageHistory);
        this.response.setContentType("text/xml");
        this.response.setContent(this.context.pageFactory.render(velocityContext, "pageHistoryXML.vm"));
        return this.response;
    }

    private boolean formatIsXML(Request request) {
        return request.getInput("format") != null && request.getInput("format").toString().toLowerCase().equals("xml");
    }

    private Response tryToMakeTestExecutionReport(Request request) {
        Date resultDate;
        String date = (String)request.getInput("resultDate");
        if ("latest".equals(date)) {
            resultDate = this.pageHistory.getLatestDate();
        } else {
            try {
                resultDate = this.dateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid date format provided", e);
            }
        }
        TestResultRecord testResultRecord = this.pageHistory.get(resultDate);
        try {
            return this.makeTestExecutionReportResponse(request, resultDate, testResultRecord);
        }
        catch (Exception e) {
            return this.makeCorruptFileResponse(request);
        }
    }

    private Response makeCorruptFileResponse(Request request) {
        return new ErrorResponder("Corrupt Test Result File").makeResponse(this.context, request);
    }

    private Response makeTestExecutionReportResponse(Request request, Date resultDate, TestResultRecord testResultRecord) throws Exception {
        if (this.formatIsXML(request)) {
            return this.generateXMLResponse(testResultRecord.getFile());
        }
        String content = FileUtil.getFileContent(testResultRecord.getFile());
        ExecutionReport report = ExecutionReport.makeReport(content);
        if (report instanceof TestExecutionReport) {
            report.setDate(resultDate);
            return this.generateHtmlTestExecutionResponse(request, (TestExecutionReport)report);
        }
        if (report instanceof SuiteExecutionReport) {
            this.pageTitle.setPageType("Suite History");
            return this.generateHtmlSuiteExecutionResponse(request, (SuiteExecutionReport)report);
        }
        return this.makeCorruptFileResponse(request);
    }

    private Response generateHtmlSuiteExecutionResponse(Request request, SuiteExecutionReport report) throws Exception {
        this.page.setTitle("Suite Execution Report");
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.put("suiteExecutionReport", report);
        this.page.put("ExecutionResult", ExecutionResult.class);
        this.page.setMainTemplate("suiteExecutionReport");
        return this.makeResponse();
    }

    private Response generateHtmlTestExecutionResponse(Request request, TestExecutionReport report) throws Exception {
        this.page.setTitle("Test Execution Report");
        this.page.setNavTemplate("viewNav");
        this.page.put("viewLocation", request.getResource());
        this.page.put("testExecutionReport", report);
        this.page.put("ExecutionResult", ExecutionResult.class);
        this.page.setMainTemplate("testExecutionReport");
        this.page.setErrorNavTemplate("errorNavigator");
        this.page.put("errorNavOnDocumentReady", true);
        return this.makeResponse();
    }

    private Response generateXMLResponse(File file) {
        try {
            this.response.setContent(FileUtil.getFileContent(file));
        }
        catch (IOException e) {
            this.response.setContent("Error: Unable to read file '" + file.getName() + "'\n");
        }
        this.response.setContentType(Response.Format.XML);
        return this.response;
    }

    private Response makeResponse() {
        this.response.setContent(this.page.html());
        return this.response;
    }

    private void prepareResponse(Request request) {
        this.response = new SimpleResponse();
        if (this.resultsDirectory == null) {
            this.resultsDirectory = this.context.getTestHistoryDirectory();
        }
        TestHistory history = new TestHistory();
        String pageName = request.getResource();
        history.readPageHistoryDirectory(this.resultsDirectory, pageName);
        this.pageHistory = history.getPageHistory(pageName);
        this.page = this.context.pageFactory.newPage();
        String tags = "";
        if (this.context.root != null) {
            WikiPagePath path = PathParser.parse(pageName);
            PageCrawler crawler = this.context.root.getPageCrawler();
            WikiPage wikiPage = crawler.getPage(path);
            if (wikiPage != null) {
                PageData pageData = wikiPage.getData();
                tags = pageData.getAttribute("Suites");
            }
        }
        this.pageTitle = new PageTitle("Test History", PathParser.parse(request.getResource()), tags);
        this.page.setPageTitle(this.pageTitle);
    }

    public void setResultsDirectory(File resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

