/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.FileUpdate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ReplacingFileUpdate
extends FileUpdate {
    public ReplacingFileUpdate(String source, String destination) {
        super(source, destination);
    }

    @Override
    public void doUpdate() throws IOException {
        if (this.destinationFile().exists()) {
            this.destinationFile().delete();
        }
        super.doUpdate();
    }

    @Override
    public boolean shouldBeApplied() throws IOException {
        if (super.shouldBeApplied()) {
            return true;
        }
        URL resource = this.getResource(this.source);
        if (resource != null) {
            long destinationSum;
            long sourceSum = this.checkSum(resource.openStream());
            return sourceSum != (destinationSum = this.checkSum(new FileInputStream(this.destinationFile())));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkSum(InputStream input) throws IOException {
        try {
            int b;
            long sum = 0L;
            while ((b = input.read()) != -1) {
                sum += (long)b;
            }
            long l = sum;
            return l;
        }
        finally {
            input.close();
        }
    }
}

