/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.Updater;
import fitnesse.updates.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdaterBase
implements Updater {
    protected static final Logger LOG = Logger.getLogger(UpdaterBase.class.getName());
    public FitNesseContext context;
    public Properties rootProperties;
    public Update[] updates;

    public UpdaterBase(FitNesseContext context) throws IOException {
        this.context = context;
        this.rootProperties = this.loadProperties();
    }

    public Properties getProperties() {
        return this.rootProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        File propFile = this.getPropertiesFile();
        if (propFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propFile);
                properties.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return properties;
    }

    private File getPropertiesFile() {
        String filename = this.context.getRootPagePath() + "/properties";
        return new File(filename);
    }

    public void saveProperties() throws IOException {
        OutputStream os = null;
        File propFile = null;
        try {
            propFile = this.getPropertiesFile();
            os = new FileOutputStream(propFile);
            this.rootProperties.store(os, "#FitNesse properties");
        }
        catch (IOException e) {
            String fileName = propFile != null ? propFile.getAbsolutePath() : "<unknown>";
            LOG.log(Level.SEVERE, "Filed to save properties file: \"" + fileName + "\". (exception: " + e + ")");
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    @Override
    public boolean update() throws IOException {
        Update[] updates = this.getUpdates();
        for (int i = 0; i < updates.length; ++i) {
            Update update = updates[i];
            if (!update.shouldBeApplied()) continue;
            this.performUpdate(update);
        }
        this.saveProperties();
        return true;
    }

    private void performUpdate(Update update) {
        try {
            update.doUpdate();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Update failed", e);
        }
    }

    private Update[] getUpdates() {
        return this.updates;
    }
}

