/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.service.EventRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/migrate")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MigrationController {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationController.class);
    private static final String[] propsToCopy = new String[]{"branch", "browser", "environment", "repositoryUrl", "suiteFilter", "suiteName", "webdriver"};
    private final EventRepository eventRepository;
    private final RepositoryService repository;
    private static boolean alreadyMigrated = false;

    @Autowired
    public MigrationController(EventRepository eventRepository, RepositoryService repository) {
        this.eventRepository = eventRepository;
        this.repository = repository;
    }

    @GET
    @Path(value="/")
    public Response migrate(@Context UriInfo uriInfo) {
        String feedback = "";
        try {
            MultivaluedMap queryParameters = uriInfo.getQueryParameters();
            String host = null;
            if (queryParameters.get((Object)"host") != null) {
                host = (String)((List)queryParameters.get((Object)"host")).get(0);
            }
            String port = null;
            if (queryParameters.get((Object)"port") != null) {
                port = (String)((List)queryParameters.get((Object)"port")).get(0);
            }
            if (host != null && port != null && !alreadyMigrated) {
                URL oldBaseUrl = new URL("http://" + host + ":" + port);
                if (this.checkMigratable(oldBaseUrl)) {
                    LOG.info("migration started");
                    alreadyMigrated = true;
                    this.migrateJCRReports();
                    feedback = this.migrateES(oldBaseUrl);
                } else {
                    feedback = "Sorry, can't migrate as I can't reach your old ElasticSearch on host " + host + " and port " + port;
                }
            } else {
                feedback = alreadyMigrated ? "Sorry, can't migrate. It seems you already did. Restart server when in doubt" : "Sorry, can't migrate. I expected two query parameters: host=<hostname> and port=<portnumber>";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)400).build();
        }
        return Response.ok((Object)feedback).build();
    }

    private void migrateJCRReports() {
        Report compositePerTeam = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        compositePerTeam.setId("Configuration/Reports/CompositePerTeam");
        compositePerTeam.setProperty("title", "Test Results per team");
        compositePerTeam.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerTeam});
        Report bar = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        bar.setId("Configuration/Reports/barchart");
        bar.setProperty("scriptLocation", "reports/GraphReport.py");
        bar.setProperty("drilldownsequence", "team, application, applicationPackage, usecase, testcase");
        bar.setProperty("drilldown", compositePerTeam);
        bar.setProperty("useTeamInDrillDown", true);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{bar});
        Report pie = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.PieReport")).newInstance("");
        pie.setId("Configuration/Reports/pie");
        pie.setProperty("scriptLocation", "reports/PieReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{pie});
        Report details = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        details.setId("Configuration/Reports/drilldown");
        details.setProperty("scriptLocation", "reports/drilldowndetails.ftl");
        details.setProperty("reportType", "html");
        details.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{details});
        compositePerTeam.setProperty("topLeft", bar);
        compositePerTeam.setProperty("topRight", pie);
        compositePerTeam.setProperty("bottom", details);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerTeam});
        Report compositePerApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        compositePerApp.setId("Configuration/Reports/CompositePerApp");
        compositePerApp.setProperty("title", "Test Results");
        compositePerApp.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerApp});
        Report barchartPerApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        barchartPerApp.setId("Configuration/Reports/barchartPerApp");
        barchartPerApp.setProperty("scriptLocation", "reports/GraphReport.py");
        barchartPerApp.setProperty("drilldownsequence", "application, applicationPackage, usecase, testcase");
        barchartPerApp.setProperty("drilldown", compositePerApp);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{barchartPerApp});
        compositePerApp.setProperty("topLeft", barchartPerApp);
        compositePerApp.setProperty("topRight", pie);
        compositePerApp.setProperty("bottom", details);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{compositePerApp});
        Report monitor = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        monitor.setId("Configuration/Reports/monitor");
        monitor.setProperty("title", "Test Automation Results");
        monitor.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitor});
        Report monitorApp = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.CompositeReport")).newInstance("");
        monitorApp.setId("Configuration/Reports/monitorApp");
        monitorApp.setProperty("title", "Test Automation Results Per App");
        monitorApp.setProperty("scriptLocation", "reports/CompositeReport.py");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorApp});
        Report monitorChart = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorChart.setId("Configuration/Reports/Monitor chart");
        monitorChart.setProperty("scriptLocation", "reports/DashboardReport.py");
        monitorChart.setProperty("drilldownsequence", "team, application, applicationPackage, usecase");
        monitorChart.setProperty("drilldown", monitor);
        monitorChart.setProperty("useTeamInDrillDown", true);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorChart});
        Report monitorAppChart = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorAppChart.setId("Configuration/Reports/Monitor APP chart");
        monitorAppChart.setProperty("scriptLocation", "reports/DashboardReport.py");
        monitorAppChart.setProperty("drilldownsequence", "team, application, usecase, testcase");
        monitorAppChart.setProperty("drilldown", monitorApp);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorAppChart});
        Report monitorPie = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"xltest.GraphReport")).newInstance("");
        monitorPie.setId("Configuration/Reports/Monitor pie chart");
        monitorPie.setProperty("scriptLocation", "reports/DashboardPieReport.py");
        monitorPie.setProperty("drilldownsequence", "team, application, applicationPackage, usecase, testcase");
        monitorPie.setProperty("drilldown", monitor);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorPie});
        Report monitorNavigation = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        monitorNavigation.setId("Configuration/Reports/Monitor navigation chart");
        monitorNavigation.setProperty("scriptLocation", "reports/monitorBottom.ftl");
        monitorNavigation.setProperty("reportType", "html");
        monitorNavigation.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorNavigation});
        Report monitorAppNavigation = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        monitorAppNavigation.setId("Configuration/Reports/Monitor APP navigation chart");
        monitorAppNavigation.setProperty("scriptLocation", "reports/monitorBottomApp.ftl");
        monitorAppNavigation.setProperty("reportType", "html");
        monitorAppNavigation.setProperty("maxRunsInHistory", 10);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorAppNavigation});
        monitor.setProperty("topLeft", monitorChart);
        monitor.setProperty("topRight", monitorPie);
        monitor.setProperty("bottom", monitorNavigation);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitor});
        monitorApp.setProperty("topLeft", monitorAppChart);
        monitorApp.setProperty("topRight", monitorPie);
        monitorApp.setProperty("bottom", monitorAppNavigation);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{monitorApp});
        Report jobsPerSlave = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"freemarker.Report")).newInstance("");
        jobsPerSlave.setId("Configuration/Reports/jobsPerSlave");
        jobsPerSlave.setProperty("scriptLocation", "reports/jobsPerSlave.ftl");
        jobsPerSlave.setProperty("reportType", "html");
        jobsPerSlave.setProperty("iconName", "none");
        jobsPerSlave.setProperty("userFriendlyDescription", "Jobs per slave report");
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{jobsPerSlave});
        Report freemarkerDuration = (Report)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.FreemarkerReportWithHistory")).newInstance("");
        freemarkerDuration.setId("Configuration/Reports/BolDuration");
        freemarkerDuration.setProperty("scriptLocation", "reports/durationdetails.ftl");
        freemarkerDuration.setProperty("reportType", "html");
        freemarkerDuration.setProperty("iconName", "none");
        freemarkerDuration.setProperty("userFriendlyDescription", "Tabular duration report");
        freemarkerDuration.setProperty("maxRunsInHistory", 20);
        this.repository.createOrUpdate((ConfigurationItem[])new Report[]{freemarkerDuration});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMigratable(URL oldBaseUrl) {
        block7: {
            HttpURLConnection connToOldES = null;
            try {
                URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_mapping");
                connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
                int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
                LOG.info("Connected to old ESs. Resp. code on old: " + responseCodeOnOldMappingUrl);
                if (responseCodeOnOldMappingUrl == 200) {
                    break block7;
                }
                LOG.error("Could not connect to one or both ES instances, see above.....");
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (connToOldES != null) {
                    connToOldES.disconnect();
                }
            }
        }
        LOG.info("Found old ES so we have a migratable situation");
        return true;
    }

    private String migrateES(URL oldBaseUrl) {
        long now = System.currentTimeMillis();
        Map<String, List<Event>> jobStatusEventsPerRunId = this.migrateRuns(oldBaseUrl);
        int nResults = this.migrateResults(oldBaseUrl, jobStatusEventsPerRunId);
        long durationInMillies = System.currentTimeMillis() - now;
        long durationInSec = durationInMillies / 1000L;
        long durationInMin = durationInSec / 60L;
        long durationInHrs = durationInMin / 60L;
        durationInSec = durationInSec - durationInHrs * 60L * 60L - (durationInMin -= durationInHrs * 60L) * 60L;
        String feedback = "Migration done in " + durationInHrs + " hrs " + durationInMin + " min " + durationInSec + " sec, and there were " + nResults + " test result events found in " + jobStatusEventsPerRunId.keySet().size() + " test runs";
        LOG.info(feedback);
        return feedback;
    }

    private Map<String, List<Event>> migrateRuns(URL oldBaseUrl) {
        LOG.info("Searching jobStatus events. This may take a while as there are hundreds of thousands of them....");
        Map<String, List<Event>> jobStatusEventsPerRunId = this.getJobStatusEventsPerRunId(oldBaseUrl);
        LOG.info("I found " + jobStatusEventsPerRunId.keySet().size() + " run_ids in jobStatus events");
        List<Event> startTestRunEvents = this.getStartOrFinishTestRunEvents(oldBaseUrl, "startTestRun", jobStatusEventsPerRunId);
        List<Event> finishTestRunEvents = this.getStartOrFinishTestRunEvents(oldBaseUrl, "finishTestRun", jobStatusEventsPerRunId);
        Set<String> runIdsStartedButNotFinished = this.getRunIdsStartedButNotFinished(startTestRunEvents, finishTestRunEvents);
        LOG.info("I found " + startTestRunEvents.size() + " start events and " + finishTestRunEvents.size() + " finish events");
        List<Event> additionalFinishTestRunEvents = this.compensateMissingFinishes(runIdsStartedButNotFinished, jobStatusEventsPerRunId);
        LOG.info("I found " + additionalFinishTestRunEvents.size() + " additional finish events after compensating");
        LOG.info("Now I have started: " + startTestRunEvents.size() + " start events " + (finishTestRunEvents.size() + additionalFinishTestRunEvents.size()) + " finish events in total");
        int totalInserted = 0;
        int inserted = 0;
        inserted = this.insertEvents(startTestRunEvents, " start run events");
        LOG.info("Inserted " + inserted + " start events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(finishTestRunEvents, " finish run events");
        LOG.info("Inserted " + inserted + " finish events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertCorrespondingImportEvents(finishTestRunEvents);
        LOG.info("Inserted " + inserted + " corresponding import events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(additionalFinishTestRunEvents, " additional finish run events");
        LOG.info("Inserted " + inserted + " additional finish events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertCorrespondingImportEvents(additionalFinishTestRunEvents);
        LOG.info("Inserted " + inserted + " additional corresponding import events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(jobStatusEventsPerRunId);
        LOG.info("Inserted " + inserted + " jobStatus events. Total of inserted events is now: " + (totalInserted += inserted));
        return jobStatusEventsPerRunId;
    }

    private int insertCorrespondingImportEvents(List<Event> finishRunEvents) {
        ArrayList<Event> importEvents = new ArrayList<Event>();
        for (Event finishRunEvent : finishRunEvents) {
            HashMap<String, Object> otherProperties = new HashMap<String, Object>();
            otherProperties.put("runId", finishRunEvent.get("runId"));
            otherProperties.put("timestamp", finishRunEvent.get("timestamp"));
            otherProperties.put("lastModified", finishRunEvent.get("timestamp"));
            otherProperties.put("testSpecification", finishRunEvent.get("testSpecification"));
            Event importEvent = new Event("importStarted", otherProperties);
            importEvents.add(importEvent);
        }
        return this.insertEvents(importEvents, " import events");
    }

    private int insertEvents(Map<String, List<Event>> jobStatusEventsPerRunId) {
        int cnt = 0;
        for (String runid : jobStatusEventsPerRunId.keySet()) {
            cnt += this.insertEvents(jobStatusEventsPerRunId.get(runid), " jobStatus events for run " + runid);
        }
        return cnt;
    }

    private int insertEvents(List<Event> events, String progressInfo) {
        boolean printProgress = events.size() > 2000;
        int cnt = 0;
        for (Event event : events) {
            this.insertEvent(event);
            if (!printProgress || ++cnt % 1000 != 999) continue;
            LOG.info("Inserted " + (cnt + 1) + " events out of " + events.size() + progressInfo);
        }
        return cnt;
    }

    private void insertEvent(Event event) {
        try {
            this.eventRepository.insert(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Event> compensateMissingFinishes(Set<String> runIdsStartedButNotFinished, Map<String, List<Event>> jobStatusEventsPerRunId) {
        ArrayList<Event> missingFinishEvents = new ArrayList<Event>();
        for (String runId : runIdsStartedButNotFinished) {
            if (jobStatusEventsPerRunId.get(runId) == null) continue;
            Event lastFinishedJobStatus = this.getLastFinishTimeEvent(jobStatusEventsPerRunId.get(runId));
            HashMap<String, Object> otherProperties = new HashMap<String, Object>();
            otherProperties.put("testSpecification", this.convertToSimpleName((String)lastFinishedJobStatus.get("testSpecification")));
            otherProperties.put("runId", runId);
            otherProperties.put("timestamp", lastFinishedJobStatus.get("timestamp"));
            this.addParameters(otherProperties, jobStatusEventsPerRunId.get(runId).get(0));
            Event compensatedFinishEvent = new Event("executionFinished", otherProperties);
            missingFinishEvents.add(compensatedFinishEvent);
        }
        return missingFinishEvents;
    }

    private String convertToSimpleName(String testSpecification) {
        if (testSpecification != null && testSpecification.startsWith("Configuration/TestSetDefinitions/")) {
            return testSpecification.substring(testSpecification.lastIndexOf("/") + 1);
        }
        return testSpecification;
    }

    private Event getLastFinishTimeEvent(List<Event> list) {
        Event lastFinishTimeEvent = null;
        for (Event jobStatus : list) {
            if (lastFinishTimeEvent == null) {
                lastFinishTimeEvent = jobStatus;
                continue;
            }
            String lastFinishTimeEventFinishTime = (String)lastFinishTimeEvent.get("finishedTime");
            String jobStatusFinishTime = (String)jobStatus.get("finishedTime");
            if (lastFinishTimeEventFinishTime == null || jobStatusFinishTime == null || Long.parseLong(lastFinishTimeEventFinishTime) >= Long.parseLong(jobStatusFinishTime)) continue;
            lastFinishTimeEvent = jobStatus;
        }
        return lastFinishTimeEvent;
    }

    private Set<String> getRunIdsStartedButNotFinished(List<Event> startTestRunEvents, List<Event> finishTestRunEvents) {
        Set<String> startedRunIds = this.getRunIdsFromEvents(startTestRunEvents);
        Set<String> finishedRunIds = this.getRunIdsFromEvents(finishTestRunEvents);
        startedRunIds.removeAll(finishedRunIds);
        return startedRunIds;
    }

    private Set<String> getRunIdsFromEvents(List<Event> startTestRunEvents) {
        HashSet<String> runIds = new HashSet<String>();
        for (Event ev : startTestRunEvents) {
            String runId = (String)ev.get("runId");
            runIds.add(runId);
        }
        return runIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getStartOrFinishTestRunEvents(URL oldBaseUrl, String startOrFinish, Map<String, List<Event>> jobStatusEventsPerRunId) {
        ArrayList<Event> startTestRunEvents = new ArrayList<Event>();
        HttpURLConnection connToOldES = null;
        HttpURLConnection connToNewES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:" + startOrFinish + "&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                for (int i = 0; i < realHits.size(); ++i) {
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                    for (String key : source.keySet()) {
                        if (key.equals("testSetId")) {
                            String convertToSimpleName = this.convertToSimpleName((String)source.get((Object)key));
                            otherProperties.put("testSpecification", convertToSimpleName);
                        }
                        if (key.equals("run_id")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (!key.equals("_ts")) continue;
                        otherProperties.put("timestamp", source.get((Object)key));
                    }
                    if (jobStatusEventsPerRunId.get(source.get((Object)"run_id")) != null) {
                        this.addParameters(otherProperties, jobStatusEventsPerRunId.get(source.get((Object)"run_id")).get(0));
                    }
                    String modernType = "executionStarted";
                    if ("finishTestRun".equals(startOrFinish)) {
                        modernType = "executionFinished";
                    }
                    Event modernEvent = new Event(modernType, otherProperties);
                    startTestRunEvents.add(modernEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the " + startOrFinish + " type");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (connToNewES != null) {
                connToNewES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return startTestRunEvents;
    }

    private void addParameters(Map<String, Object> properties, Event event) {
        for (int i = 0; i < propsToCopy.length; ++i) {
            if (!event.hasProperty(propsToCopy[i])) continue;
            properties.put(propsToCopy[i], event.get(propsToCopy[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Event>> getJobStatusEventsPerRunId(URL oldBaseUrl) {
        HashMap<String, List<Event>> jobStatusEventsPerRunId = new HashMap<String, List<Event>>();
        HashSet<String> alreadyCreatedSpecifications = new HashSet<String>();
        HttpURLConnection connToOldES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:jobStatus&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                LOG.info("Have to process " + realHits.size() + " jobStatus Events");
                for (int i = 0; i < realHits.size(); ++i) {
                    String testSpecification;
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                    if (i % 1000 == 999) {
                        LOG.info("Processed " + (i + 1) + " jobStatus Events");
                    }
                    for (String key : source.keySet()) {
                        if (key.equals("testSetDefinition")) {
                            otherProperties.put("testSpecification", this.convertToSimpleName((String)source.get((Object)key)));
                        }
                        if (key.equals("runId")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (key.equals("run_id")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (key.equals("_ts")) {
                            otherProperties.put("timestamp", source.get((Object)key));
                        }
                        if (key.equals("startTime")) {
                            otherProperties.put("startTime", source.get((Object)key));
                        }
                        if (key.equals("finishedTime")) {
                            otherProperties.put("finishedTime", source.get((Object)key));
                        }
                        if (key.equals("status")) {
                            otherProperties.put("status", source.get((Object)key));
                            if (source.get((Object)"status").equals("finished")) {
                                Number started = (Number)source.get((Object)"started");
                                long duration = 0L;
                                if (started != null && source.get((Object)"_ts") != null) {
                                    duration = ((Number)source.get((Object)"_ts")).longValue() - started.longValue();
                                }
                                otherProperties.put("started", started);
                                otherProperties.put("duration", duration);
                                otherProperties.put("result", source.get((Object)"reason"));
                                otherProperties.put("slave", source.get((Object)"slave"));
                            }
                        }
                        if (key.equals("suiteName")) {
                            otherProperties.put("suiteName", source.get((Object)key));
                        }
                        if (key.equals("jenkinsUri")) {
                            LOG.debug("Found jenkins URI {}", source.get((Object)key));
                            otherProperties.put("jenkinsUri", source.get((Object)key));
                        }
                        if (key.equals("jobName")) {
                            otherProperties.put("jobName", source.get((Object)key));
                        }
                        if (key.equals("slave")) {
                            otherProperties.put("slave", source.get((Object)key));
                        }
                        if (key.equals("timeout")) {
                            otherProperties.put("timeout", source.get((Object)key));
                        }
                        if (key.equals("ntests")) {
                            otherProperties.put("ntests", source.get((Object)key));
                        }
                        if (key.equals("buildNumber")) {
                            otherProperties.put("buildNumber", source.get((Object)key));
                        }
                        if (key.equals("browser")) {
                            otherProperties.put("browser", source.get((Object)key));
                        }
                        if (key.equals("team")) {
                            otherProperties.put("team", source.get((Object)key));
                        }
                        if (key.equals("environment")) {
                            otherProperties.put("environment", source.get((Object)key));
                        }
                        if (!key.equals("testset")) continue;
                        otherProperties.put("name", this.semicolonSeparate((String)source.get((Object)"testset")));
                    }
                    Event jobStatusEvent = new Event("jobStatus", otherProperties);
                    if (jobStatusEventsPerRunId.get(jobStatusEvent.get("runId")) == null) {
                        jobStatusEventsPerRunId.put(jobStatusEvent.get("runId").toString(), new ArrayList());
                    }
                    if (jobStatusEvent.hasProperty("testSpecification") && !alreadyCreatedSpecifications.contains(testSpecification = (String)jobStatusEvent.get("testSpecification"))) {
                        Host host = null;
                        if (jobStatusEvent.hasProperty("jenkinsUri") && jobStatusEvent.hasProperty("jobName")) {
                            host = this.createJenkinsHostInJcr((String)jobStatusEvent.get("jenkinsUri"), testSpecification, (String)jobStatusEvent.get("jobName"));
                        }
                        this.createTestSpecificationInJcr(testSpecification, host);
                        alreadyCreatedSpecifications.add(testSpecification);
                    }
                    ((List)jobStatusEventsPerRunId.get(jobStatusEvent.get("runId").toString())).add(jobStatusEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the jobStatus type");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return jobStatusEventsPerRunId;
    }

    private Host createJenkinsHostInJcr(String jenkinsUri, String testSpecification, String jobName) {
        Host host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.JenkinsHost")).newInstance("");
        host.setId("Infrastructure/" + testSpecification + " Host");
        host.setProperty("address", (Object)jenkinsUri);
        host.setProperty("jobName", (Object)jobName);
        this.repository.createOrUpdate((ConfigurationItem[])new Host[]{host});
        LOG.info("New jenkins host created in JCR " + host.getId());
        return host;
    }

    private void createTestSpecificationInJcr(String testSpecificationName, Host host) {
        TestSpecification ts = (TestSpecification)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"bol.SlicedFitNesse")).newInstance("");
        ts.setId("Configuration/TestSpecifications/" + testSpecificationName);
        ts.setTestToolName("FitNesse");
        ts.setSearchPattern("**");
        ts.setWorkingDirectory(".");
        ts.setProperty("importTestResults", false);
        ts.setProperty("commandLine", "-");
        ts.setProperty("timeout", 0);
        if (host != null) {
            ts.setHost(host);
        }
        this.repository.createOrUpdate((ConfigurationItem[])new TestSpecification[]{ts});
        LOG.info("New test specification created in JCR " + ts.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int migrateResults(URL oldBaseUrl, Map<String, List<Event>> jobStatusEventsPerRunId) {
        HttpURLConnection connToOldES = null;
        InputStream inputStream = null;
        int cnt = 0;
        try {
            for (String runId : jobStatusEventsPerRunId.keySet()) {
                URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:result%20AND%20run_id:\"" + runId + "\"&size=1000000");
                connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
                int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
                if (responseCodeOnOldMappingUrl == 200) {
                    inputStream = connToOldES.getInputStream();
                    JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                    JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                    JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                    LOG.info("Have to process " + realHits.size() + " Result Events");
                    String testSpecification = (String)jobStatusEventsPerRunId.get(runId).get(0).get("testSpecification");
                    for (int i = 0; i < realHits.size(); ++i) {
                        JSONObject resultEvent = (JSONObject)realHits.get(i);
                        JSONObject source = (JSONObject)resultEvent.get((Object)"_source");
                        HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                        if (i % 1000 == 999) {
                            LOG.info("Processed " + (i + 1) + " result Events");
                        }
                        for (String key : source.keySet()) {
                            if (key.equals("result")) {
                                otherProperties.put("result", source.get((Object)key));
                            }
                            if (key.equals("buildNumber")) {
                                otherProperties.put("buildNumber", source.get((Object)key));
                            }
                            if (key.equals("issue")) {
                                otherProperties.put("issue", source.get((Object)key));
                            }
                            if (key.equals("issue")) {
                                otherProperties.put("issue", source.get((Object)key));
                            }
                            if (key.equals("testcasedescription")) {
                                otherProperties.put("testcasedescription", source.get((Object)key));
                            }
                            if (key.equals("buildUrl")) {
                                otherProperties.put("buildUrl", source.get((Object)key));
                            }
                            if (key.equals("priority")) {
                                otherProperties.put("priority", source.get((Object)key));
                            }
                            if (key.equals("browser")) {
                                otherProperties.put("browser", source.get((Object)key));
                            }
                            if (key.equals("_ts")) {
                                otherProperties.put("timestamp", source.get((Object)key));
                            }
                            if (key.equals("tags")) {
                                otherProperties.put("tags", source.get((Object)key));
                            }
                            if (key.equals("pageName")) {
                                otherProperties.put("pageName", source.get((Object)key));
                            }
                            if (key.equals("firstError")) {
                                otherProperties.put("firstError", source.get((Object)key));
                            }
                            if (key.equals("properties")) {
                                otherProperties.put("properties", source.get((Object)key));
                            }
                            if (key.equals("team")) {
                                otherProperties.put("team", source.get((Object)key));
                            }
                            if (key.equals("environment")) {
                                otherProperties.put("environment", source.get((Object)key));
                            }
                            if (key.equals("run_id")) {
                                otherProperties.put("runId", source.get((Object)key));
                            }
                            if (key.equals("testset")) {
                                otherProperties.put("name", this.semicolonSeparate((String)source.get((Object)key)));
                            }
                            if (key.equals("jobName")) {
                                otherProperties.put("jobName", source.get((Object)key));
                            }
                            if (!key.equals("time")) continue;
                            otherProperties.put("duration", source.get((Object)key));
                        }
                        otherProperties.put("duration", 0);
                        otherProperties.put("testSpecification", testSpecification);
                        ++cnt;
                        Event functionalResult = new Event("functionalResult", otherProperties);
                        this.eventRepository.insert(functionalResult);
                    }
                    continue;
                }
                LOG.error("Could not retrieve instances of the jobStatus type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return cnt;
    }

    private String semicolonSeparate(String fitNesseTestCaseName) {
        return fitNesseTestCaseName.replaceAll("\\.", ";");
    }
}

