/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSetIterator;
import org.apache.lucene.util.RamUsageEstimator;

public final class FixedBitSet
extends DocIdSet
implements Bits {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
    final long[] bits;
    final int numBits;
    final int numWords;

    public static FixedBitSet ensureCapacity(FixedBitSet bits, int numBits) {
        long[] arr;
        if (numBits < bits.length()) {
            return bits;
        }
        int numWords = FixedBitSet.bits2words(numBits);
        if (numWords >= (arr = bits.getBits()).length) {
            arr = ArrayUtil.grow(arr, numWords + 1);
        }
        return new FixedBitSet(arr, arr.length << 6);
    }

    public static int bits2words(int numBits) {
        int numLong = numBits >>> 6;
        if ((numBits & 0x3F) != 0) {
            ++numLong;
        }
        return numLong;
    }

    public static long intersectionCount(FixedBitSet a, FixedBitSet b) {
        return BitUtil.pop_intersect(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
    }

    public static long unionCount(FixedBitSet a, FixedBitSet b) {
        long tot = BitUtil.pop_union(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
        if (a.numWords < b.numWords) {
            tot += BitUtil.pop_array(b.bits, a.numWords, b.numWords - a.numWords);
        } else if (a.numWords > b.numWords) {
            tot += BitUtil.pop_array(a.bits, b.numWords, a.numWords - b.numWords);
        }
        return tot;
    }

    public static long andNotCount(FixedBitSet a, FixedBitSet b) {
        long tot = BitUtil.pop_andnot(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
        if (a.numWords > b.numWords) {
            tot += BitUtil.pop_array(a.bits, b.numWords, a.numWords - b.numWords);
        }
        return tot;
    }

    public FixedBitSet(int numBits) {
        this.numBits = numBits;
        this.bits = new long[FixedBitSet.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public FixedBitSet(long[] storedBits, int numBits) {
        this.numWords = FixedBitSet.bits2words(numBits);
        if (this.numWords > storedBits.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + numBits + " bits");
        }
        this.numBits = numBits;
        this.bits = storedBits;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new FixedBitSetIterator(this.bits, this.numBits, this.numWords);
    }

    @Override
    public Bits bits() {
        return this;
    }

    @Override
    public int length() {
        return this.numBits;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bits);
    }

    public long[] getBits() {
        return this.bits;
    }

    public int cardinality() {
        return (int)BitUtil.pop_array(this.bits, 0, this.bits.length);
    }

    @Override
    public boolean get(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public void set(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public boolean getAndSet(int index) {
        assert (index >= 0 && index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public void clear(int index) {
        assert (index >= 0 && index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getAndClear(int index) {
        assert (index >= 0 && index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public int nextSetBit(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = index >> 6;
        int subIndex = index & 0x3F;
        long word = this.bits[i] >> subIndex;
        if (word != 0L) {
            return index + Long.numberOfTrailingZeros(word);
        }
        while (++i < this.numWords) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return -1;
    }

    public int prevSetBit(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int i = index >> 6;
        int subIndex = index & 0x3F;
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    public void or(DocIdSetIterator iter) throws IOException {
        if (iter instanceof OpenBitSetIterator && iter.docID() == -1) {
            OpenBitSetIterator obs = (OpenBitSetIterator)iter;
            this.or(obs.arr, obs.words);
            obs.advance(this.numBits);
        } else if (iter instanceof FixedBitSetIterator && iter.docID() == -1) {
            FixedBitSetIterator fbs = (FixedBitSetIterator)iter;
            this.or(fbs.bits, fbs.numWords);
            fbs.advance(this.numBits);
        } else {
            int doc;
            while ((doc = iter.nextDoc()) < this.numBits) {
                this.set(doc);
            }
        }
    }

    public void or(FixedBitSet other) {
        this.or(other.bits, other.numWords);
    }

    private void or(long[] otherArr, int otherNumWords) {
        assert (otherNumWords <= this.numWords) : "numWords=" + this.numWords + ", otherNumWords=" + otherNumWords;
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
    }

    public void xor(FixedBitSet other) {
        assert (other.numWords <= this.numWords) : "numWords=" + this.numWords + ", other.numWords=" + other.numWords;
        long[] thisBits = this.bits;
        long[] otherBits = other.bits;
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            int n = pos;
            thisBits[n] = thisBits[n] ^ otherBits[pos];
        }
    }

    public void xor(DocIdSetIterator iter) throws IOException {
        int doc;
        while ((doc = iter.nextDoc()) < this.numBits) {
            this.flip(doc, doc + 1);
        }
    }

    public void and(DocIdSetIterator iter) throws IOException {
        if (iter instanceof OpenBitSetIterator && iter.docID() == -1) {
            OpenBitSetIterator obs = (OpenBitSetIterator)iter;
            this.and(obs.arr, obs.words);
            obs.advance(this.numBits);
        } else if (iter instanceof FixedBitSetIterator && iter.docID() == -1) {
            FixedBitSetIterator fbs = (FixedBitSetIterator)iter;
            this.and(fbs.bits, fbs.numWords);
            fbs.advance(this.numBits);
        } else {
            int disiDoc;
            if (this.numBits == 0) {
                return;
            }
            int bitSetDoc = this.nextSetBit(0);
            while (bitSetDoc != -1 && (disiDoc = iter.advance(bitSetDoc)) < this.numBits) {
                this.clear(bitSetDoc, disiDoc);
                bitSetDoc = ++disiDoc < this.numBits ? this.nextSetBit(disiDoc) : -1;
            }
            if (bitSetDoc != -1) {
                this.clear(bitSetDoc, this.numBits);
            }
        }
    }

    public boolean intersects(FixedBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void and(FixedBitSet other) {
        this.and(other.bits, other.numWords);
    }

    private void and(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.numWords > otherNumWords) {
            Arrays.fill(thisArr, otherNumWords, this.numWords, 0L);
        }
    }

    public void andNot(DocIdSetIterator iter) throws IOException {
        if (iter instanceof OpenBitSetIterator && iter.docID() == -1) {
            OpenBitSetIterator obs = (OpenBitSetIterator)iter;
            this.andNot(obs.arr, obs.words);
            obs.advance(this.numBits);
        } else if (iter instanceof FixedBitSetIterator && iter.docID() == -1) {
            FixedBitSetIterator fbs = (FixedBitSetIterator)iter;
            this.andNot(fbs.bits, fbs.numWords);
            fbs.advance(this.numBits);
        } else {
            int doc;
            while ((doc = iter.nextDoc()) < this.numBits) {
                this.clear(doc);
            }
        }
    }

    public void andNot(FixedBitSet other) {
        this.andNot(other.bits, other.bits.length);
    }

    private void andNot(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & (otherArr[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void flip(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits);
        assert (endIndex >= 0 && endIndex <= this.numBits);
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public void set(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits);
        assert (endIndex >= 0 && endIndex <= this.numBits);
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    public void clear(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0 && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, 0L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] & endmask;
    }

    public FixedBitSet clone() {
        long[] bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bits, 0, bits.length);
        return new FixedBitSet(bits, this.numBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedBitSet)) {
            return false;
        }
        FixedBitSet other = (FixedBitSet)o;
        if (this.numBits != other.length()) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    public static final class FixedBitSetIterator
    extends DocIdSetIterator {
        final int numBits;
        final int numWords;
        final long[] bits;
        int doc = -1;

        public FixedBitSetIterator(FixedBitSet bits) {
            this(bits.bits, bits.numBits, bits.numWords);
        }

        public FixedBitSetIterator(long[] bits, int numBits, int wordLength) {
            this.bits = bits;
            this.numBits = numBits;
            this.numWords = wordLength;
        }

        @Override
        public int nextDoc() {
            if (this.doc == Integer.MAX_VALUE || ++this.doc >= this.numBits) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int i = this.doc >> 6;
            int subIndex = this.doc & 0x3F;
            long word = this.bits[i] >> subIndex;
            if (word != 0L) {
                return this.doc += Long.numberOfTrailingZeros(word);
            }
            while (++i < this.numWords) {
                word = this.bits[i];
                if (word == 0L) continue;
                this.doc = (i << 6) + Long.numberOfTrailingZeros(word);
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.numBits;
        }

        @Override
        public int advance(int target) {
            if (this.doc == Integer.MAX_VALUE || target >= this.numBits) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int i = target >> 6;
            int subIndex = target & 0x3F;
            long word = this.bits[i] >> subIndex;
            if (word != 0L) {
                this.doc = target + Long.numberOfTrailingZeros(word);
                return this.doc;
            }
            while (++i < this.numWords) {
                word = this.bits[i];
                if (word == 0L) continue;
                this.doc = (i << 6) + Long.numberOfTrailingZeros(word);
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
    }
}

