<#macro RESULTTYPE result title>
<tr>
  <th colspan="5"><h3>${title}</h3></th>
</tr>
<tr>
    <th>Test</th><th>Full name</th>
</tr>
<#assign prefix = queryParameters['prefix']!"">
<#assign depth = prefix?split(";")?size>
<#list events as event>
  <#assign name = event.get('name')!"" >
  <#if prefix == "">
    <#assign nameMatches = true>
  <#else>
    <#assign nameMatches = name?starts_with(prefix)>
  </#if>
  <#if event.type == 'functionalResult' && event.get('result') == result && nameMatches>
    <tr>
      <#list name?split(";") as x>
        <#if !x_has_next>
          <#assign testName = x>
        </#if>
      </#list>
        <td>${testName}</td>
        <td>${name}</td>
    </tr>
    <tr class="secondary">
      <td colspan="4">
        <#if depth &gt; 3>
          <#assign correspondingOlderEvents = testRuns.getCorrespondingEventsFromOlderRuns(testRun, event, this.getProperty('maxRunsInHistory'), 'type', 'name')>
          <#assign thisResult = event.get('result')!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.get('result')!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>

          <#assign flaky = ((nChanges / total) * 100)?floor >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
                <#list correspondingOlderEvents as olderEvent>
                  <#assign oldResult = olderEvent.get('result')!"">
                  <#assign report_id = this.getId() >
                  <#assign runId = olderEvent.get('runId') >
                  <#assign team = olderEvent.get('team')!"" >
                  <#assign name = olderEvent.get('name') >
                  <#assign level0 = "">
                  <#assign level1 = "">
                  <#assign level2 = "">
                  <#assign level3 = "">
                  <#list name?split(";") as x>
                    <#if x_index == 0>
                      <#assign level0 = x>
                    </#if>
                    <#if x_index == 1>
                      <#assign level1 = x>
                    </#if>
                    <#if x_index == 2>
                      <#assign level2 = x>
                    </#if>
                    <#if x_index == 3>
                      <#assign level3 = x>
                    </#if>
                  </#list>
                  <#assign runDay = this.thisDay(olderEvent.get('timestamp')) >
                  <#if oldResult == "PASSED">
                    <td bgcolor="#9ada7f">
                  <#else>
                    <td bgcolor="#fd8d10">
                  </#if>
                  <a href="#/reports/${runId}/${report_id}?prefix=${level0};${level1};${level2};${level3}">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</#macro>

<#assign events = testRun.getEvents() >

<table class="table two-rows">
<tbody>
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</tbody>
</table>

