from parser.xunit import validate_files, parse_last_modified, parse_junit_test_results


def surefire_last_modified(file):
    # maven surefire generates no timestamp in result files, hence we fall back to the file timestamp
    return int(file.lastModified())


def is_new_run(last_modified):
    return last_modified > test_run_historian.timeOfLatestTestRun()


validate_files(files)

last_modified = parse_last_modified(files, extract_last_modified=surefire_last_modified)

if is_new_run(last_modified):
    events = parse_junit_test_results(files, last_modified)
else:
    events = []

# Result holder should contain a list of test runs. A test run is a list of events

result_holder.result = [events] if events else []
