from parser.xunit import throw_if_some_failed, get_root_node, parse_last_modified, parse_junit_test_results, extract_result, openFile
from xml.etree import ElementTree as ET
from datetime import datetime
from com.xebialabs.xlt.plugin.api.resultparser import MalformedInputException

def validate_files(files):
    filtered = []
    for file in files:
        if str(file).endswith("xml"):
            root = get_root_node(file)
            if root.tag == "testsuites":
                filtered.append(file)
    throw_if_some_failed(files, filtered)

def karma_iterate_test_cases(file):
    """
    Iterate all test cases found in `file`.
    :param file:
    :return: a list/iterator of tuples (test case node, test hierarchy path)
    """
    with openFile(file) as f:
        et_iter = iter(ET.iterparse(f, events=('start', 'end',)))
        for event, elem in et_iter:
            if event == 'end' and elem.tag == 'testcase':
                yield (elem, [elem.attrib['name']])
                elem.clear()

def karma_failure_reason(testCase):
    if extract_result(testCase) == "FAILED":
        failure = testCase.find("failure")
        if failure is not None:
            if failure.text:
                return str(failure.text).strip()
            else:
                return "No failure reason"
        else:
            raise MalformedInputException("Expected to have found a failure reason!")
    else:
        return None

def karma_last_modified(file):
    with openFile(file) as f:
        et_iter = iter(ET.iterparse(f, events=('start', 'end',)))
        max = datetime(1970, 1, 1)
        for event, elem in et_iter:
            if event == 'start' and elem.tag == 'testsuite':
                timestamp = elem.attrib["timestamp"]
                current = datetime.strptime(timestamp, "%Y-%m-%dT%H:%M:%S")
                if current > max:
                    max = current
            elem.clear()
    return int(((max - datetime(1970, 1, 1)).total_seconds() * 1000))

validate_files(files)

last_modified = parse_last_modified(files, extract_last_modified=karma_last_modified)

if not test_run_historian.isKnownKey(str(last_modified)):
    events = parse_junit_test_results(files, last_modified,
                                      iterate_test_cases=karma_iterate_test_cases,
                                      extract_failure_reason=karma_failure_reason)
else:
    events = []

# Result holder should contain a list of test runs. A test run is a list of events

result_holder.result = [events] if events else []
