package com.xebialabs.xltest.testtools.fitnesse;

import com.xebialabs.xlt.plugin.api.testrun.Event;

import java.util.*;

public class TestSummary {
    public final List<String> hierarchy;
    public final Set<String> tags;
    public final long lastModified;
    public final int duration;
    public final int right;
    public final int wrong;
    public final String result;
    public final int exceptions;
    public final String firstError;

    public TestSummary(List<String> hierarchy, Set<String> tags, long lastModified, int duration, int right, int wrong, int exceptions, String firstError) {
        this.hierarchy = hierarchy;
        this.tags = tags;
        this.lastModified = lastModified;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.result = wrong + exceptions > 0 ? "FAILED" : "PASSED";
        this.exceptions = exceptions;
        this.firstError = firstError;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hierarchy, tags, lastModified, duration, right, wrong, result, exceptions, firstError);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final TestSummary that = (TestSummary) o;
        return Objects.equals(lastModified, that.lastModified) &&
            Objects.equals(duration, that.duration) &&
            Objects.equals(right, that.right) &&
            Objects.equals(wrong, that.wrong) &&
            Objects.equals(exceptions, that.exceptions) &&
            Objects.equals(hierarchy, that.hierarchy) &&
            Objects.equals(tags, that.tags) &&
            Objects.equals(result, that.result) &&
            Objects.equals(firstError, that.firstError);
    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put(Event.HIERARCHY, hierarchy);
        // TODO: fix tags defined by test tools
//        map.put("tags", tags);
        map.put(Event.TESTED_AT, lastModified);
        map.put(Event.DURATION, duration);
        map.put("right", right);
        map.put("wrong", wrong);
        map.put(Event.RESULT, result);
        map.put("exceptions", exceptions);
        if (firstError != null) {
            map.put(Event.FIRST_ERROR, firstError);
        }
        return map;
    }
}
