/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.testtools.fitnesse;

import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.testtools.fitnesse.FitnesseSuiteImporterFactory;
import fitnesse.reporting.history.SuiteExecutionReport;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitNesseSuiteImporter {
    private static final Logger LOG = LoggerFactory.getLogger(FitNesseSuiteImporter.class);
    private FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory;
    private final SuiteExecutionReport executionReport;
    private final String pageName;

    public FitNesseSuiteImporter(FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory, SuiteExecutionReport executionReport, String pageName) {
        this.fitnesseSuiteImporterFactory = fitnesseSuiteImporterFactory;
        this.executionReport = executionReport;
        this.pageName = pageName;
    }

    public long getLastModified() {
        return this.executionReport.getDate().getTime();
    }

    public String getPageName() {
        return this.pageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> mapSuiteToEvents(String testRunId) throws ImportException {
        LOG.debug("doImport({}, {})", (Object)testRunId, (Object)this.pageName);
        ArrayList<Event> result = new ArrayList<Event>();
        result.add(Event.create((String)"importStarted", (Object[])new Object[]{"@testedAt", this.getLastModified(), "@runKey", Long.toString(this.getLastModified())}));
        try {
            result.addAll(this.fitnesseSuiteImporterFactory.produceEventsForReport(testRunId, this.executionReport));
        }
        catch (Throwable throwable) {
            int duration = (int)this.executionReport.getTotalRunTimeInMillis();
            result.add(Event.create((String)"importFinished", (Object[])new Object[]{"@runId", testRunId, "@duration", duration}));
            throw throwable;
        }
        int duration = (int)this.executionReport.getTotalRunTimeInMillis();
        result.add(Event.create((String)"importFinished", (Object[])new Object[]{"@runId", testRunId, "@duration", duration}));
        return result;
    }

    public String toString() {
        return this.pageName + " " + this.getLastModified();
    }
}

