/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.xunit;

import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Importable;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XUnitReportXmlImporter
implements Importable {
    public static final char SEPARATOR = ';';
    private final OverthereFile xunitReportXmlFile;
    private final String moduleName;

    public XUnitReportXmlImporter(String moduleName, OverthereFile xunitReportXmlFile) {
        this.moduleName = moduleName;
        this.xunitReportXmlFile = xunitReportXmlFile;
    }

    public void doImport(UUID testRunId, EventHandler eventHandler) throws Exception {
        NodeList testSuites;
        eventHandler.onReceive(new Event(testRunId, "importStarted", Event.props((Object[])new Object[]{"fileName", this.xunitReportXmlFile.getPath(), "lastModified", this.xunitReportXmlFile.lastModified()})));
        try (InputStream fis = this.xunitReportXmlFile.getInputStream();){
            testSuites = this.parse(fis);
            if (testSuites == null) {
                return;
            }
        }
        long totalDuration = 0L;
        String sourceFile = this.xunitReportXmlFile.getName();
        for (int i = 0; i < testSuites.getLength(); ++i) {
            Element testSuite = (Element)testSuites.item(i);
            long testSuiteDuration = this.getDuration(testSuite);
            totalDuration += testSuiteDuration;
            this.tellAboutTestSuite(testSuite, testRunId, eventHandler, sourceFile);
        }
        eventHandler.onReceive(new Event(testRunId, "importFinished", Event.props((Object[])new Object[]{"duration", totalDuration})));
    }

    private long getDuration(Element testSuite) {
        String timeInSecondsAsString = testSuite.getAttribute("time");
        if (timeInSecondsAsString == null || timeInSecondsAsString.equals("")) {
            return 0L;
        }
        float timeInSecondsAsFloat = Float.parseFloat(timeInSecondsAsString);
        return (long)((double)timeInSecondsAsFloat * 1000.0);
    }

    private NodeList parse(InputStream fis) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fis);
            return doc.getElementsByTagName("testsuite");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void tellAboutTestSuite(Element testSuite, UUID testRunId, EventHandler eventHandler, String testResultFilename) throws Exception {
        String prefix = (Strings.isNullOrEmpty((String)this.moduleName) ? "" : this.moduleName + ';') + XUnitReportXmlImporter.formatSuiteName(this.readAttribute(testSuite, "name"));
        NodeList testCases = testSuite.getElementsByTagName("testcase");
        int length = testCases.getLength();
        for (int i = 0; i < length; ++i) {
            Element testCase = (Element)testCases.item(i);
            eventHandler.onReceive(new Event(testRunId, "functionalResult", Event.props((Object[])new Object[]{"result", this.testCaseResult(testCase), "duration", this.testCaseDurationInMilliSeconds(testCase), "name", prefix + ';' + this.readAttribute(testCase, "name"), "fileName", testResultFilename})));
        }
    }

    private String readAttribute(Element testSuite, String attribute) {
        return testSuite.getAttribute(attribute);
    }

    private String testCaseResult(Element testCase) {
        NodeList failureNodes = testCase.getElementsByTagName("failure");
        if (failureNodes == null || failureNodes.getLength() == 0) {
            return "PASSED";
        }
        return "FAILED";
    }

    private long testCaseDurationInMilliSeconds(Element testCase) {
        String duration = this.readAttribute(testCase, "time");
        if (duration == null || "".equals(duration)) {
            return 0L;
        }
        Float f = Float.valueOf(Float.parseFloat(duration));
        return (long)(f.floatValue() * 1000.0f);
    }

    static String formatSuiteName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        String packageName = name.substring(0, lastDot);
        String className = name.substring(lastDot + 1);
        if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)className)) {
            return name;
        }
        return packageName + ';' + className;
    }
}

