/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.iterators.AbstractTestMapIterator;
import org.apache.commons.collections.map.AbstractTestMap;

public abstract class AbstractTestBidiMap
extends AbstractTestMap {
    private static final Object[][] entriesKV = new Object[][]{{"key1", "value1"}, {"key2", "value2"}, {"key3", "value3"}};
    private static final Object[][] entriesVK = new Object[][]{{"value1", "key1"}, {"value2", "key2"}, {"value3", "key3"}};
    protected final Object[][] entries;

    public AbstractTestBidiMap(String testName) {
        super(testName);
        this.entries = entriesKV;
    }

    public AbstractTestBidiMap() {
        super("Inverse");
        this.entries = entriesVK;
    }

    public abstract BidiMap makeEmptyBidiMap();

    public BidiMap makeFullBidiMap() {
        BidiMap map = this.makeEmptyBidiMap();
        for (int i = 0; i < this.entries.length; ++i) {
            map.put(this.entries[i][0], this.entries[i][1]);
        }
        return map;
    }

    public final Map makeEmptyMap() {
        return this.makeEmptyBidiMap();
    }

    public boolean isAllowDuplicateValues() {
        return false;
    }

    public String getCompatibilityVersion() {
        return "3";
    }

    public void testBidiPut() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        BidiMap map = this.makeEmptyBidiMap();
        BidiMap inverse = map.inverseBidiMap();
        AbstractTestBidiMap.assertEquals((int)0, (int)map.size());
        AbstractTestBidiMap.assertEquals((int)map.size(), (int)inverse.size());
        map.put((Object)"A", (Object)"B");
        AbstractTestBidiMap.assertEquals((int)1, (int)map.size());
        AbstractTestBidiMap.assertEquals((int)map.size(), (int)inverse.size());
        AbstractTestBidiMap.assertEquals((Object)"B", (Object)map.get((Object)"A"));
        AbstractTestBidiMap.assertEquals((Object)"A", (Object)inverse.get((Object)"B"));
        map.put((Object)"A", (Object)"C");
        AbstractTestBidiMap.assertEquals((int)1, (int)map.size());
        AbstractTestBidiMap.assertEquals((int)map.size(), (int)inverse.size());
        AbstractTestBidiMap.assertEquals((Object)"C", (Object)map.get((Object)"A"));
        AbstractTestBidiMap.assertEquals((Object)"A", (Object)inverse.get((Object)"C"));
        map.put((Object)"B", (Object)"C");
        AbstractTestBidiMap.assertEquals((int)1, (int)map.size());
        AbstractTestBidiMap.assertEquals((int)map.size(), (int)inverse.size());
        AbstractTestBidiMap.assertEquals((Object)"C", (Object)map.get((Object)"B"));
        AbstractTestBidiMap.assertEquals((Object)"B", (Object)inverse.get((Object)"C"));
        map.put((Object)"E", (Object)"F");
        AbstractTestBidiMap.assertEquals((int)2, (int)map.size());
        AbstractTestBidiMap.assertEquals((int)map.size(), (int)inverse.size());
        AbstractTestBidiMap.assertEquals((Object)"F", (Object)map.get((Object)"E"));
        AbstractTestBidiMap.assertEquals((Object)"E", (Object)inverse.get((Object)"F"));
    }

    public void verify() {
        this.verifyInverse();
        super.verify();
    }

    public void verifyInverse() {
        AbstractTestBidiMap.assertEquals((int)this.map.size(), (int)((BidiMap)this.map).inverseBidiMap().size());
        HashMap map1 = new HashMap(this.map);
        HashMap map2 = new HashMap(((BidiMap)this.map).inverseBidiMap());
        Set keys1 = map1.keySet();
        Set keys2 = map2.keySet();
        Collection values1 = map1.values();
        Collection values2 = map2.values();
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)keys1.containsAll(values2));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)values2.containsAll(keys1));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)values1.containsAll(keys2));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)keys2.containsAll(values1));
    }

    public void testBidiGetKey() {
        this.doTestGetKey(this.makeFullBidiMap(), this.entries[0][0], this.entries[0][1]);
    }

    public void testBidiGetKeyInverse() {
        this.doTestGetKey(this.makeFullBidiMap().inverseBidiMap(), this.entries[0][1], this.entries[0][0]);
    }

    private final void doTestGetKey(BidiMap map, Object key, Object value) {
        AbstractTestBidiMap.assertEquals((String)"Value not found for key.", (Object)value, (Object)map.get(key));
        AbstractTestBidiMap.assertEquals((String)"Key not found for value.", (Object)key, (Object)map.getKey(value));
    }

    public void testBidiInverse() {
        BidiMap map = this.makeFullBidiMap();
        BidiMap inverseMap = map.inverseBidiMap();
        AbstractTestBidiMap.assertSame((String)"Inverse of inverse is not equal to original.", (Object)map, (Object)inverseMap.inverseBidiMap());
        AbstractTestBidiMap.assertEquals((String)"Value not found for key.", (Object)this.entries[0][0], (Object)inverseMap.get(this.entries[0][1]));
        AbstractTestBidiMap.assertEquals((String)"Key not found for value.", (Object)this.entries[0][1], (Object)inverseMap.getKey(this.entries[0][0]));
    }

    public void testBidiModifyEntrySet() {
        if (!this.isSetValueSupported()) {
            return;
        }
        this.modifyEntrySet(this.makeFullBidiMap());
        this.modifyEntrySet(this.makeFullBidiMap().inverseBidiMap());
    }

    private final void modifyEntrySet(BidiMap map) {
        Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
        Object key = entry.getKey();
        Object oldValue = entry.getValue();
        String newValue = "newValue";
        entry.setValue(newValue);
        AbstractTestBidiMap.assertEquals((String)"Modifying entrySet did not affect underlying Map.", (Object)newValue, (Object)map.get(key));
        AbstractTestBidiMap.assertNull((String)"Modifying entrySet did not affect inverse Map.", (Object)map.getKey(oldValue));
    }

    public void testBidiClear() {
        if (!this.isRemoveSupported()) {
            try {
                this.makeFullBidiMap().clear();
                AbstractTestBidiMap.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        BidiMap map = this.makeFullBidiMap();
        map.clear();
        AbstractTestBidiMap.assertTrue((String)"Map was not cleared.", (boolean)map.isEmpty());
        AbstractTestBidiMap.assertTrue((String)"Inverse map was not cleared.", (boolean)map.inverseBidiMap().isEmpty());
        map = this.makeFullBidiMap().inverseBidiMap();
        map.clear();
        AbstractTestBidiMap.assertTrue((String)"Map was not cleared.", (boolean)map.isEmpty());
        AbstractTestBidiMap.assertTrue((String)"Inverse map was not cleared.", (boolean)map.inverseBidiMap().isEmpty());
    }

    public void testBidiRemove() {
        if (!this.isRemoveSupported()) {
            try {
                this.makeFullBidiMap().remove(this.entries[0][0]);
                AbstractTestBidiMap.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            try {
                this.makeFullBidiMap().removeValue(this.entries[0][1]);
                AbstractTestBidiMap.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.remove(this.makeFullBidiMap(), this.entries[0][0]);
        this.remove(this.makeFullBidiMap().inverseBidiMap(), this.entries[0][1]);
        this.removeValue(this.makeFullBidiMap(), this.entries[0][1]);
        this.removeValue(this.makeFullBidiMap().inverseBidiMap(), this.entries[0][0]);
        AbstractTestBidiMap.assertEquals(null, (Object)this.makeFullBidiMap().removeValue((Object)"NotPresent"));
    }

    private final void remove(BidiMap map, Object key) {
        Object value = map.remove(key);
        AbstractTestBidiMap.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertNull((String)"Value was not removed.", (Object)map.getKey(value));
    }

    private final void removeValue(BidiMap map, Object value) {
        Object key = map.removeValue(value);
        AbstractTestBidiMap.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertNull((String)"Value was not removed.", (Object)map.getKey(value));
    }

    public void testBidiKeySetValuesOrder() {
        this.resetFull();
        Iterator keys = this.map.keySet().iterator();
        Iterator values = this.map.values().iterator();
        while (keys.hasNext() && values.hasNext()) {
            Object key = keys.next();
            Object value = values.next();
            AbstractTestBidiMap.assertSame(this.map.get(key), value);
        }
        AbstractTestBidiMap.assertEquals((boolean)false, (boolean)keys.hasNext());
        AbstractTestBidiMap.assertEquals((boolean)false, (boolean)values.hasNext());
    }

    public void testBidiRemoveByKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByKeySet(this.makeFullBidiMap(), this.entries[0][0], this.entries[0][1]);
        this.removeByKeySet(this.makeFullBidiMap().inverseBidiMap(), this.entries[0][1], this.entries[0][0]);
    }

    private final void removeByKeySet(BidiMap map, Object key, Object value) {
        map.keySet().remove(key);
        AbstractTestBidiMap.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Value was not removed.", (!map.containsValue(value) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Key was not removed from inverse map.", (!map.inverseBidiMap().containsValue(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Value was not removed from inverse map.", (!map.inverseBidiMap().containsKey(value) ? 1 : 0) != 0);
    }

    public void testBidiRemoveByEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByEntrySet(this.makeFullBidiMap(), this.entries[0][0], this.entries[0][1]);
        this.removeByEntrySet(this.makeFullBidiMap().inverseBidiMap(), this.entries[0][1], this.entries[0][0]);
    }

    private final void removeByEntrySet(BidiMap map, Object key, Object value) {
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        temp.put(key, value);
        map.entrySet().remove(temp.entrySet().iterator().next());
        AbstractTestBidiMap.assertTrue((String)"Key was not removed.", (!map.containsKey(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Value was not removed.", (!map.containsValue(value) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Key was not removed from inverse map.", (!map.inverseBidiMap().containsValue(key) ? 1 : 0) != 0);
        AbstractTestBidiMap.assertTrue((String)"Value was not removed from inverse map.", (!map.inverseBidiMap().containsKey(value) ? 1 : 0) != 0);
    }

    public BulkTest bulkTestMapEntrySet() {
        return new TestBidiMapEntrySet();
    }

    public BulkTest bulkTestInverseMap() {
        return new TestInverseBidiMap(this);
    }

    public BulkTest bulkTestBidiMapIterator() {
        return new TestBidiMapIterator();
    }

    public void testBidiMapIteratorSet() {
        Object newValue1 = this.getOtherValues()[0];
        Object newValue2 = this.getOtherValues()[1];
        this.resetFull();
        BidiMap bidi = (BidiMap)this.map;
        MapIterator it = bidi.mapIterator();
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key1 = it.next();
        if (!this.isSetValueSupported()) {
            try {
                it.setValue(newValue1);
                AbstractTestBidiMap.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        AbstractTestBidiMap.assertSame((Object)key1, (Object)it.getKey());
        AbstractTestBidiMap.assertSame((Object)newValue1, (Object)it.getValue());
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsKey(key1));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractTestBidiMap.assertEquals((Object)newValue1, (Object)bidi.get(key1));
        this.verify();
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        AbstractTestBidiMap.assertSame((Object)key1, (Object)it.getKey());
        AbstractTestBidiMap.assertSame((Object)newValue1, (Object)it.getValue());
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsKey(key1));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractTestBidiMap.assertEquals((Object)newValue1, (Object)bidi.get(key1));
        this.verify();
        Object key2 = it.next();
        it.setValue(newValue2);
        this.confirmed.put(key2, newValue2);
        AbstractTestBidiMap.assertSame((Object)key2, (Object)it.getKey());
        AbstractTestBidiMap.assertSame((Object)newValue2, (Object)it.getValue());
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsKey(key2));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue2));
        AbstractTestBidiMap.assertEquals((Object)newValue2, (Object)bidi.get(key2));
        this.verify();
        try {
            it.setValue(newValue1);
            AbstractTestBidiMap.fail();
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        this.confirmed.put(key2, newValue1);
        this.confirmed.remove(key1);
        AbstractTestBidiMap.assertEquals((Object)newValue1, (Object)it.getValue());
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsKey(it.getKey()));
        AbstractTestBidiMap.assertEquals((boolean)true, (boolean)bidi.containsValue(newValue1));
        AbstractTestBidiMap.assertEquals((Object)newValue1, (Object)bidi.get(it.getKey()));
        AbstractTestBidiMap.assertEquals((boolean)false, (boolean)bidi.containsKey(key1));
        AbstractTestBidiMap.assertEquals((boolean)false, (boolean)bidi.containsValue(newValue2));
        this.verify();
        it.next();
        if (this.isRemoveSupported()) {
            it.remove();
        }
    }

    public class TestBidiMapIterator
    extends AbstractTestMapIterator {
        public TestBidiMapIterator() {
            super("TestBidiMapIterator");
        }

        public Object[] addSetValues() {
            return AbstractTestBidiMap.this.getNewSampleValues();
        }

        public boolean supportsRemove() {
            return AbstractTestBidiMap.this.isRemoveSupported();
        }

        public boolean supportsSetValue() {
            return AbstractTestBidiMap.this.isSetValueSupported();
        }

        public MapIterator makeEmptyMapIterator() {
            AbstractTestBidiMap.this.resetEmpty();
            return ((BidiMap)AbstractTestBidiMap.this.map).mapIterator();
        }

        public MapIterator makeFullMapIterator() {
            AbstractTestBidiMap.this.resetFull();
            return ((BidiMap)AbstractTestBidiMap.this.map).mapIterator();
        }

        public Map getMap() {
            return AbstractTestBidiMap.this.map;
        }

        public Map getConfirmedMap() {
            return AbstractTestBidiMap.this.confirmed;
        }

        public void verify() {
            super.verify();
            AbstractTestBidiMap.this.verify();
        }
    }

    public class TestInverseBidiMap
    extends AbstractTestBidiMap {
        final AbstractTestBidiMap main;

        public TestInverseBidiMap(AbstractTestBidiMap main) {
            this.main = main;
        }

        public BidiMap makeEmptyBidiMap() {
            return this.main.makeEmptyBidiMap().inverseBidiMap();
        }

        public BidiMap makeFullBidiMap() {
            return this.main.makeFullBidiMap().inverseBidiMap();
        }

        public Map makeFullMap() {
            return ((BidiMap)this.main.makeFullMap()).inverseBidiMap();
        }

        public Object[] getSampleKeys() {
            return this.main.getSampleValues();
        }

        public Object[] getSampleValues() {
            return this.main.getSampleKeys();
        }

        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion();
        }

        public boolean isAllowNullKey() {
            return this.main.isAllowNullKey();
        }

        public boolean isAllowNullValue() {
            return this.main.isAllowNullValue();
        }

        public boolean isPutAddSupported() {
            return this.main.isPutAddSupported();
        }

        public boolean isPutChangeSupported() {
            return this.main.isPutChangeSupported();
        }

        public boolean isSetValueSupported() {
            return this.main.isSetValueSupported();
        }

        public boolean isRemoveSupported() {
            return this.main.isRemoveSupported();
        }
    }

    public class TestBidiMapEntrySet
    extends AbstractTestMap.TestMapEntrySet {
        public TestBidiMapEntrySet() {
            super(AbstractTestBidiMap.this);
        }

        public void testMapEntrySetIteratorEntrySetValueCrossCheck() {
            Object key1 = AbstractTestBidiMap.this.getSampleKeys()[0];
            Object key2 = AbstractTestBidiMap.this.getSampleKeys()[1];
            Object newValue1 = AbstractTestBidiMap.this.getNewSampleValues()[0];
            Object newValue2 = AbstractTestBidiMap.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.collection.iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.collection.iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.confirmed.iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.confirmed.iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractTestBidiMap.this.isSetValueSupported()) {
                try {
                    entry1.setValue(newValue1);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            try {
                entry2.setValue(newValue1);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            entryConfirmed2.setValue(newValue1);
            AbstractTestBidiMap.this.confirmed.remove(key1);
            TestBidiMapEntrySet.assertEquals((Object)newValue1, entry2.getValue());
            TestBidiMapEntrySet.assertEquals((boolean)true, (boolean)AbstractTestBidiMap.this.map.containsKey(entry2.getKey()));
            TestBidiMapEntrySet.assertEquals((boolean)true, (boolean)AbstractTestBidiMap.this.map.containsValue(newValue1));
            TestBidiMapEntrySet.assertEquals((Object)newValue1, AbstractTestBidiMap.this.map.get(entry2.getKey()));
            TestBidiMapEntrySet.assertEquals((boolean)false, (boolean)AbstractTestBidiMap.this.map.containsKey(key1));
            TestBidiMapEntrySet.assertEquals((boolean)false, (boolean)AbstractTestBidiMap.this.map.containsValue(newValue2));
            this.verify();
            it.next();
            if (this.isRemoveSupported()) {
                it.remove();
            }
        }
    }
}

