/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.AbstractTestObject;

public abstract class AbstractTestIterator
extends AbstractTestObject {
    public AbstractTestIterator(String testName) {
        super(testName);
    }

    public abstract Iterator makeEmptyIterator();

    public abstract Iterator makeFullIterator();

    public Object makeObject() {
        return this.makeFullIterator();
    }

    public boolean supportsEmptyIterator() {
        return true;
    }

    public boolean supportsFullIterator() {
        return true;
    }

    public boolean supportsRemove() {
        return true;
    }

    public void verify() {
    }

    public void testEmptyIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        Iterator it = this.makeEmptyIterator();
        AbstractTestIterator.assertEquals((String)"hasNext() should return false for empty iterators", (boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            AbstractTestIterator.fail((String)"NoSuchElementException must be thrown when Iterator is exhausted");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.verify();
        AbstractTestIterator.assertNotNull((Object)it.toString());
    }

    public void testFullIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        Iterator it = this.makeFullIterator();
        AbstractTestIterator.assertEquals((String)"hasNext() should return true for at least one element", (boolean)true, (boolean)it.hasNext());
        try {
            it.next();
        }
        catch (NoSuchElementException e) {
            AbstractTestIterator.fail((String)"Full iterators must have at least one element");
        }
        while (it.hasNext()) {
            it.next();
            this.verify();
        }
        try {
            it.next();
            AbstractTestIterator.fail((String)"NoSuchElementException must be thrown when Iterator is exhausted");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        AbstractTestIterator.assertNotNull((Object)it.toString());
    }

    public void testRemove() {
        Iterator it = this.makeFullIterator();
        if (!this.supportsRemove()) {
            try {
                it.remove();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        try {
            it.remove();
            AbstractTestIterator.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
        it.next();
        it.remove();
        try {
            it.remove();
            AbstractTestIterator.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

