/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.aggregation.stage.TerminalStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.IllegalOperationException;
import de.bwaldvogel.mongo.oplog.NoopOplog;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutStage
extends TerminalStage {
    private static final Logger log = LoggerFactory.getLogger(OutStage.class);
    private final MongoDatabase database;
    private final String collectionName;

    public OutStage(MongoDatabase database, Object collectionName) {
        this.database = database;
        this.collectionName = (String)collectionName;
    }

    @Override
    public String name() {
        return "$out";
    }

    @Override
    public void applyLast(Stream<Document> stream) {
        if (this.collectionName.contains("$")) {
            throw new IllegalOperationException("error with target namespace: Invalid collection name: " + this.collectionName);
        }
        String tempCollectionName = "_tmp" + System.currentTimeMillis() + "_" + this.collectionName;
        MongoCollection<?> tempCollection = this.database.createCollectionOrThrowIfExists(tempCollectionName);
        stream.forEach(tempCollection::addDocument);
        MongoCollection<?> existingCollection = this.database.resolveCollection(this.collectionName, false);
        if (existingCollection != null) {
            log.info("Dropping existing collection {}", existingCollection);
            this.database.dropCollection(this.collectionName, NoopOplog.get());
        }
        this.database.moveCollection(this.database, tempCollection, this.collectionName);
    }

    @Override
    public boolean isModifying() {
        return true;
    }
}

