/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.bson.BsonEncoder;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoWireMessageEncoder
extends MessageToByteEncoder<MongoMessage> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireMessageEncoder.class);

    protected void encode(ChannelHandlerContext ctx, MongoMessage message, ByteBuf buf) {
        buf.writeIntLE(0);
        buf.writeIntLE(message.getHeader().getRequestID());
        buf.writeIntLE(message.getHeader().getResponseTo());
        buf.writeIntLE(OpCode.OP_MSG.getId());
        buf.writeIntLE(message.getFlags());
        buf.writeByte(0);
        Document document = message.getDocument();
        try {
            BsonEncoder.encodeDocument(document, buf);
        }
        catch (RuntimeException e) {
            log.error("Failed to encode {}", (Object)document, (Object)e);
            ctx.channel().close();
            throw e;
        }
        log.debug("wrote message: {}", (Object)message);
        int writerIndex = buf.writerIndex();
        buf.setIntLE(0, writerIndex);
    }
}

