/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutablePackageFinderRule
implements PackageFinderRule {
    private final DistributionMatch match;
    private final PackageFinder finder;

    private ImmutablePackageFinderRule(DistributionMatch match, PackageFinder finder) {
        this.match = match;
        this.finder = finder;
    }

    @Override
    public DistributionMatch match() {
        return this.match;
    }

    @Override
    public PackageFinder finder() {
        return this.finder;
    }

    public final ImmutablePackageFinderRule withMatch(DistributionMatch value) {
        if (this.match == value) {
            return this;
        }
        DistributionMatch newValue = Objects.requireNonNull(value, "match");
        return new ImmutablePackageFinderRule(newValue, this.finder);
    }

    public final ImmutablePackageFinderRule withFinder(PackageFinder value) {
        if (this.finder == value) {
            return this;
        }
        PackageFinder newValue = Objects.requireNonNull(value, "finder");
        return new ImmutablePackageFinderRule(this.match, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePackageFinderRule && this.equalsByValue((ImmutablePackageFinderRule)another);
    }

    private boolean equalsByValue(ImmutablePackageFinderRule another) {
        return this.match.equals(another.match) && this.finder.equals(another.finder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.match.hashCode();
        h += (h << 5) + this.finder.hashCode();
        return h;
    }

    public String toString() {
        return "PackageFinderRule{match=" + this.match + ", finder=" + this.finder + "}";
    }

    public static ImmutablePackageFinderRule copyOf(PackageFinderRule instance) {
        if (instance instanceof ImmutablePackageFinderRule) {
            return (ImmutablePackageFinderRule)instance;
        }
        return ((Builder)ImmutablePackageFinderRule.builder()).match(instance.match()).finder(instance.finder()).build();
    }

    public static MatchBuildStage builder() {
        return new Builder();
    }

    public static interface BuildFinal {
        public ImmutablePackageFinderRule build();
    }

    public static interface FinderBuildStage {
        public BuildFinal finder(PackageFinder var1);
    }

    public static interface MatchBuildStage {
        public FinderBuildStage match(DistributionMatch var1);
    }

    public static final class Builder
    implements MatchBuildStage,
    FinderBuildStage,
    BuildFinal {
        private static final long INIT_BIT_MATCH = 1L;
        private static final long INIT_BIT_FINDER = 2L;
        private long initBits = 3L;
        private DistributionMatch match;
        private PackageFinder finder;

        private Builder() {
        }

        @Override
        public final Builder match(DistributionMatch match) {
            Builder.checkNotIsSet(this.matchIsSet(), "match");
            this.match = Objects.requireNonNull(match, "match");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder finder(PackageFinder finder) {
            Builder.checkNotIsSet(this.finderIsSet(), "finder");
            this.finder = Objects.requireNonNull(finder, "finder");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutablePackageFinderRule build() {
            this.checkRequiredAttributes();
            return new ImmutablePackageFinderRule(this.match, this.finder);
        }

        private boolean matchIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean finderIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PackageFinderRule is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.matchIsSet()) {
                attributes.add("match");
            }
            if (!this.finderIsSet()) {
                attributes.add("finder");
            }
            return "Cannot build PackageFinderRule, some of required attributes are not set " + attributes;
        }
    }
}

